/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class ManagedPath {
    private final Path path;
    private final List<PatchId> owners = new ArrayList<PatchId>();

    public static ManagedPath create(Path path, List<PatchId> owners) {
        return new ManagedPath(path, owners);
    }

    public static ManagedPath fromString(String line) {
        IllegalArgumentAssertion.assertNotNull(line, "line");
        int index = line.indexOf(32);
        ArrayList<PatchId> owners = new ArrayList<PatchId>();
        Path path = Paths.get(line.substring(0, index), new String[0]);
        String opart = line.substring(index + 1);
        opart = opart.substring(1, opart.length() - 1);
        for (String idspec : opart.split(",")) {
            owners.add(PatchId.fromString(idspec.trim()));
        }
        return new ManagedPath(path, owners);
    }

    private ManagedPath(Path path, List<PatchId> owners) {
        IllegalArgumentAssertion.assertNotNull(path, "path");
        IllegalArgumentAssertion.assertNotNull(owners, "owners");
        this.path = path;
        this.owners.addAll(owners);
    }

    public Path getPath() {
        return this.path;
    }

    public List<PatchId> getOwners() {
        return Collections.unmodifiableList(this.owners);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ManagedPath)) {
            return false;
        }
        ManagedPath other = (ManagedPath)obj;
        return this.path.equals(other.path) && this.owners.equals(other.owners);
    }

    public String toString() {
        return this.path + " " + this.owners;
    }
}

