/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

final class ManagedPaths {
    private final Map<Path, ManagedPath> managedPaths = new HashMap<Path, ManagedPath>();

    ManagedPaths(List<ManagedPath> managedPaths) {
        IllegalArgumentAssertion.assertNotNull(managedPaths, "managedPaths");
        for (ManagedPath mpath : managedPaths) {
            this.managedPaths.put(mpath.getPath(), mpath);
        }
    }

    List<ManagedPath> getPaths() {
        ArrayList<Path> keys = new ArrayList<Path>(this.managedPaths.keySet());
        Collections.sort(keys);
        ArrayList<ManagedPath> result = new ArrayList<ManagedPath>();
        for (Path path : keys) {
            result.add(this.managedPaths.get(path));
        }
        return Collections.unmodifiableList(result);
    }

    ManagedPaths updatePaths(SmartPatch smartPatch) {
        for (Record rec : smartPatch.getRecords()) {
            Record.Action act = rec.getAction();
            if (act == Record.Action.ADD || act == Record.Action.UPD) {
                this.addPathOwner(rec);
                continue;
            }
            if (act != Record.Action.DEL) continue;
            this.removePathOwner(rec);
        }
        return this;
    }

    private void addPathOwner(Record rec) {
        IllegalArgumentAssertion.assertNotNull(rec, "rec");
        Path path = rec.getPath();
        PatchId owner = rec.getPatchId();
        ManagedPath mpath = this.managedPaths.get(path);
        if (mpath == null) {
            mpath = ManagedPath.create(path, Collections.singletonList(owner));
            this.managedPaths.put(path, mpath);
        } else {
            ArrayList<PatchId> owners = new ArrayList<PatchId>(mpath.getOwners());
            this.removeOwner(owners, owner);
            owners.add(owner);
            mpath = ManagedPath.create(mpath.getPath(), owners);
            this.managedPaths.put(path, mpath);
        }
    }

    private void removePathOwner(Record rec) {
        IllegalArgumentAssertion.assertNotNull(rec, "rec");
        Path path = rec.getPath();
        PatchId owner = rec.getPatchId();
        ManagedPath mpath = this.managedPaths.get(path);
        if (mpath != null) {
            ArrayList<PatchId> owners = new ArrayList<PatchId>(mpath.getOwners());
            this.removeOwner(owners, owner);
            if (!owners.isEmpty()) {
                mpath = ManagedPath.create(mpath.getPath(), owners);
                this.managedPaths.put(mpath.getPath(), mpath);
            } else {
                this.managedPaths.remove(mpath.getPath());
            }
        }
    }

    private void removeOwner(List<PatchId> owners, PatchId owner) {
        Iterator<PatchId> it = owners.iterator();
        while (it.hasNext()) {
            PatchId aux = it.next();
            if (!aux.getName().equals(owner.getName())) continue;
            it.remove();
            break;
        }
    }
}

