/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

final class DefaultRepository
implements Repository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRepository.class);
    private final URL baseURL;
    private final Path rootPath;

    DefaultRepository(URL repoUrl) {
        if (repoUrl == null) {
            repoUrl = DefaultRepository.getConfiguredUrl();
        }
        IllegalStateAssertion.assertNotNull(repoUrl, "Cannot obtain repository URL");
        this.baseURL = repoUrl;
        Path path = this.getAbsolutePath(repoUrl);
        PatchAssertion.assertTrue(path.toFile().isDirectory(), "Repository root does not exist: " + path);
        LOG.debug("Repository location: {}", (Object)path);
        this.rootPath = path;
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.queryAppliedPackages(this.rootPath, prefix, false);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            List<PatchId> list = Parser.queryAppliedPackages(this.rootPath, prefix, true);
            PatchId patchId = list.isEmpty() ? null : list.get(0);
            return patchId;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public Package getPackage(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = Parser.readPackage(this.rootPath, patchId);
            return package_;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        return this.addArchive(fileUrl, null, Collections.emptySet(), false);
    }

    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId) throws IOException {
        return this.addArchive(fileUrl, oneoffId, Collections.emptySet(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatchId addArchive(URL fileUrl, PatchId oneoffId, Set<PatchId> dependencies, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(fileUrl, "fileUrl");
        IllegalArgumentAssertion.assertTrue(fileUrl.getPath().endsWith(".zip"), "Unsupported file extension: " + fileUrl);
        Lock.tryLock();
        try {
            Package patchSet;
            Path sourcePath = this.getAbsolutePath(fileUrl);
            PatchId patchId = PatchId.fromURL(fileUrl);
            PatchAssertion.assertFalse(this.queryAvailable(null).contains(patchId), "Repository already contains " + patchId);
            if (oneoffId != null) {
                File metadataFile = Parser.getMetadataFile(this.rootPath, oneoffId);
                PatchAssertion.assertTrue(metadataFile.isFile(), "Cannot obtain target patch for: " + oneoffId);
            }
            HashMap<Path, Record> combinedPathsMap = new HashMap<Path, Record>();
            for (PatchId auxid : Parser.queryAppliedPackages(this.rootPath, null, false)) {
                if (patchId.getName().equals(auxid.getName())) continue;
                for (Record rec : this.getPackage(auxid).getRecords()) {
                    combinedPathsMap.put(rec.getPath(), rec);
                }
            }
            ZipInputStream zipInput = new ZipInputStream(new FileInputStream(sourcePath.toFile()));
            Iterator<Record> iterator = null;
            try {
                if (oneoffId != null) {
                    Package oneoffSet = this.getPackage(oneoffId);
                    HashMap<Path, Record> records = new HashMap<Path, Record>();
                    for (Record record : oneoffSet.getRecords()) {
                        records.put(record.getPath(), record);
                    }
                    Package sourceSet = Parser.buildPackageFromZip(patchId, Record.Action.INFO, zipInput);
                    for (Record rec : sourceSet.getRecords()) {
                        records.put(rec.getPath(), rec);
                    }
                    LinkedHashSet<PatchId> linkedHashSet = new LinkedHashSet<PatchId>(dependencies);
                    linkedHashSet.add(oneoffId);
                    patchSet = Package.create(patchId, records.values(), linkedHashSet);
                } else {
                    Package sourceSet = Parser.buildPackageFromZip(patchId, Record.Action.INFO, zipInput);
                    patchSet = Package.create(patchId, sourceSet.getRecords(), dependencies);
                }
            }
            catch (Throwable sourceSet) {
                iterator = sourceSet;
                throw sourceSet;
            }
            finally {
                if (zipInput != null) {
                    if (iterator != null) {
                        try {
                            zipInput.close();
                        }
                        catch (Throwable sourceSet) {
                            ((Throwable)((Object)iterator)).addSuppressed(sourceSet);
                        }
                    } else {
                        zipInput.close();
                    }
                }
            }
            HashSet<PatchId> duplicates = new HashSet<PatchId>();
            for (Record rec : patchSet.getRecords()) {
                Record otherRec = (Record)combinedPathsMap.get(rec.getPath());
                if (otherRec == null) continue;
                PatchId otherId = otherRec.getPatchId();
                if (rec.getChecksum().equals(otherRec.getChecksum())) continue;
                String string = "Path '" + rec.getPath() + "' already contained in: " + otherId;
                if (force) {
                    LOG.warn(string);
                } else {
                    LOG.error(string);
                }
                duplicates.add(otherId);
            }
            PatchAssertion.assertTrue(force || duplicates.isEmpty(), "Cannot add " + patchId + " because of duplicate paths in " + duplicates);
            File targetFile = this.getPackagePath(patchId).toFile();
            targetFile.getParentFile().mkdirs();
            Files.copy(sourcePath, targetFile.toPath(), new CopyOption[0]);
            Parser.writePackage(this.rootPath, patchSet);
            if (sourcePath.startsWith(this.rootPath)) {
                sourcePath.toFile().delete();
            }
            String message = "Added " + patchId;
            if (oneoffId != null) {
                message = message + " patching " + oneoffId;
            }
            if (!dependencies.isEmpty()) {
                message = message + " with dependencies on " + dependencies;
            }
            LOG.info(message);
            PatchId patchId2 = patchId;
            return patchId2;
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    public boolean removeArchive(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            File patchdir = Parser.getMetadataDirectory(this.rootPath, patchId);
            PatchAssertion.assertTrue(patchdir.isDirectory(), "Archive does not exist: " + patchId);
            IOUtils.rmdirs(patchdir.toPath());
            LOG.info("Removed {}", (Object)patchId);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPostCommand(PatchId patchId, String[] cmdarr) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(cmdarr, "cmdarr");
        Lock.tryLock();
        try {
            Package patchSet = this.getPackage(patchId);
            ArrayList<String> commands = new ArrayList<String>(patchSet.getPostCommands());
            commands.add(this.commandString(cmdarr));
            patchSet = Package.create(patchId, patchSet.getRecords(), commands);
            try {
                Parser.writePackage(this.rootPath, patchSet);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            LOG.info("Added post install command to {}", (Object)patchId);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmartPatch getSmartPatch(Package seedPatch, PatchId patchId) {
        Lock.tryLock();
        try {
            if (patchId == null) {
                IllegalArgumentAssertion.assertNotNull(seedPatch, "seedPatch");
                patchId = this.getLatestAvailable(seedPatch.getPatchId().getName());
            }
            Package targetSet = this.getPackage(patchId);
            PatchAssertion.assertNotNull(targetSet, "Repository does not contain package: " + patchId);
            Package smartSet = Package.smartSet(seedPatch, targetSet);
            SmartPatch smartPatch = SmartPatch.forInstall(smartSet, this.getPackageURL(patchId));
            return smartPatch;
        }
        finally {
            Lock.unlock();
        }
    }

    static URL getConfiguredUrl() {
        String repoSpec = System.getProperty("fusepatch.repository");
        if (repoSpec == null) {
            repoSpec = System.getenv("FUSEPATCH_REPOSITORY");
        }
        if (repoSpec != null) {
            try {
                return new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    private String commandString(String[] cmdarr) {
        StringBuffer result = new StringBuffer();
        for (String tok : cmdarr) {
            result.append(tok + " ");
        }
        return result.toString().trim();
    }

    private Path getPackagePath(PatchId patchId) {
        return this.rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString(), patchId + ".zip"));
    }

    private URL getPackageURL(PatchId patchId) {
        try {
            return this.getPackagePath(patchId).toFile().toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Path getAbsolutePath(URL url) {
        IllegalArgumentAssertion.assertTrue("file".equals(url.getProtocol()), "Unsupported protocol: " + url);
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsoluteFile().toPath();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String toString() {
        return "DefaultRepository[rootPath=" + this.rootPath + "]";
    }
}

