/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchRepository;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.Parser;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class DefaultPatchRepository
implements PatchRepository {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPatchRepository.class);
    private final Path rootPath;

    public DefaultPatchRepository(URL repoUrl) {
        if (repoUrl == null) {
            repoUrl = DefaultPatchRepository.getConfiguredUrl();
        }
        IllegalStateAssertion.assertNotNull(repoUrl, "Cannot obtain repository URL");
        Path path = Paths.get(repoUrl.getPath(), new String[0]);
        IllegalStateAssertion.assertTrue(path.toFile().isDirectory(), "Repository root does not exist: " + path);
        this.rootPath = path.toAbsolutePath();
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        return Parser.getAvailable(this.rootPath, prefix, false);
    }

    @Override
    public PatchId getLatestAvailable(String prefix) {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        List<PatchId> list = Parser.getAvailable(this.rootPath, prefix, true);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public PatchSet getPatchSet(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        try {
            return Parser.readPatchSet(this.rootPath, patchId);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PatchId addArchive(URL fileUrl) throws IOException {
        IllegalArgumentAssertion.assertNotNull(fileUrl, "fileUrl");
        IllegalArgumentAssertion.assertTrue(fileUrl.getPath().endsWith(".zip"), "Unsupported file extension: " + fileUrl);
        Path sourcePath = Paths.get(fileUrl.getPath(), new String[0]);
        PatchId patchId = PatchId.fromFile(sourcePath.toFile());
        LOG.info("Add to repository: {}", (Object)patchId);
        PatchSet patchSet = Parser.buildPatchSetFromZip(patchId, PatchSet.Action.INFO, sourcePath.toFile());
        File targetFile = this.getPatchFile(patchId);
        targetFile.getParentFile().mkdirs();
        Files.copy(sourcePath, targetFile.toPath(), new CopyOption[0]);
        Parser.writePatchSet(this.rootPath, patchSet);
        if (sourcePath.startsWith(this.rootPath)) {
            sourcePath.toFile().delete();
        }
        return patchId;
    }

    @Override
    public void addPostCommand(PatchId patchId, String cmd) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        IllegalArgumentAssertion.assertNotNull(cmd, "cmd");
        LOG.info("Add post install command to: {}", (Object)patchId);
        PatchSet patchSet = this.getPatchSet(patchId);
        ArrayList<String> commands = new ArrayList<String>(patchSet.getPostCommands());
        commands.add(cmd);
        patchSet = PatchSet.create(patchId, patchSet.getRecords(), commands);
        try {
            Parser.writePatchSet(this.rootPath, patchSet);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public SmartPatch getSmartPatch(PatchSet seedPatch, PatchId patchId) {
        if (patchId == null) {
            IllegalArgumentAssertion.assertNotNull(seedPatch, "seedPatch");
            patchId = this.getLatestAvailable(seedPatch.getPatchId().getSymbolicName());
        }
        File zipfile = this.getPatchFile(patchId);
        IllegalStateAssertion.assertTrue(zipfile.isFile(), "Cannot obtain patch file: " + zipfile);
        PatchSet targetSet = this.getPatchSet(patchId);
        PatchSet smartSet = PatchSet.smartSet(seedPatch, targetSet);
        return new SmartPatch(smartSet, zipfile);
    }

    static URL getConfiguredUrl() {
        String repoSpec = System.getProperty("fusepatch.repository");
        if (repoSpec == null) {
            repoSpec = System.getenv("FUSEPATCH_REPOSITORY");
        }
        if (repoSpec != null) {
            try {
                return new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return null;
    }

    private File getPatchFile(PatchId patchId) {
        return this.rootPath.resolve(Paths.get(patchId.getSymbolicName(), patchId.getVersion().toString(), patchId + ".zip")).toFile();
    }
}

