/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public class IOUtils {
    public static void writeWithFlush(OutputStream output, byte[] content) throws IOException {
        IllegalArgumentAssertion.assertNotNull(output, "output");
        IllegalArgumentAssertion.assertNotNull(content, "content");
        int size = 4096;
        int offset = 0;
        while (content.length - offset > 4096) {
            output.write(content, offset, 4096);
            offset += 4096;
        }
        output.write(content, offset, content.length - offset);
        output.flush();
    }

    public static void copydirs(final Path targetDir, final Path sourceDir) throws IOException {
        IllegalArgumentAssertion.assertNotNull(targetDir, "targetDir");
        IllegalArgumentAssertion.assertNotNull(sourceDir, "sourceDir");
        Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path targetdir = targetDir.resolve(dir.relativize(sourceDir));
                targetdir.toFile().mkdirs();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void rmdirs(Path targetDir) throws IOException {
        IllegalArgumentAssertion.assertNotNull(targetDir, "targetDir");
        if (targetDir.toFile().exists()) {
            Files.walkFileTree(targetDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

