/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchSet;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;

public final class SmartPatch {
    private final File patchFile;
    private final PatchSet patchSet;
    private final Map<Path, PatchSet.Record> delMap = new HashMap<Path, PatchSet.Record>();
    private final Map<Path, PatchSet.Record> updMap = new HashMap<Path, PatchSet.Record>();
    private final Map<Path, PatchSet.Record> addMap = new HashMap<Path, PatchSet.Record>();

    public SmartPatch(PatchSet patchSet, File patchFile) {
        IllegalArgumentAssertion.assertNotNull(patchFile, "patchFile");
        IllegalArgumentAssertion.assertNotNull(patchSet, "patchSet");
        this.patchSet = patchSet;
        this.patchFile = patchFile;
        block5: for (PatchSet.Record rec : patchSet.getRecords()) {
            PatchSet.Action action = rec.getAction();
            switch (rec.getAction()) {
                case ADD: {
                    this.addMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case UPD: {
                    this.updMap.put(rec.getPath(), rec);
                    continue block5;
                }
                case DEL: {
                    this.delMap.put(rec.getPath(), rec);
                    continue block5;
                }
            }
            throw new IllegalStateException((Object)((Object)action) + " no supported");
        }
    }

    public PatchId getPatchId() {
        return this.patchSet.getPatchId();
    }

    public File getPatchFile() {
        return this.patchFile;
    }

    public List<PatchSet.Record> getRecords() {
        return this.patchSet.getRecords();
    }

    public Set<PatchId> getDependencies() {
        return this.patchSet.getDependencies();
    }

    public Set<PatchSet.Record> getRemoveSet() {
        return Collections.unmodifiableSet(new HashSet<PatchSet.Record>(this.delMap.values()));
    }

    public boolean isRemovePath(Path path) {
        return this.delMap.containsKey(path);
    }

    public Set<PatchSet.Record> getReplaceSet() {
        return Collections.unmodifiableSet(new HashSet<PatchSet.Record>(this.updMap.values()));
    }

    public boolean isReplacePath(Path path) {
        return this.updMap.containsKey(path);
    }

    public Set<PatchSet.Record> getAddSet() {
        return Collections.unmodifiableSet(new HashSet<PatchSet.Record>(this.addMap.values()));
    }

    public boolean isAddPath(Path path) {
        return this.addMap.containsKey(path);
    }

    public List<String> getPostCommands() {
        return this.patchSet.getPostCommands();
    }

    public String toString() {
        return "SmartPatch[id=" + this.patchSet.getPatchId() + ",file=" + this.patchFile + ",add=" + this.addMap.size() + ",upd=" + this.updMap.size() + ",del=" + this.delMap.size() + "]";
    }
}

