/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class Record {
    private final Action action;
    private final Path path;
    private final Long checksum;

    public static Record create(Path path) {
        return new Record(Action.INFO, path, 0L);
    }

    public static Record create(Path path, Long checksum) {
        return new Record(Action.INFO, path, checksum);
    }

    public static Record create(Action action, Path path, Long checksum) {
        return new Record(action, path, checksum);
    }

    public static Record fromString(String line) {
        IllegalArgumentAssertion.assertNotNull(line, "line");
        String[] toks = line.split("[\\s]");
        IllegalStateAssertion.assertEquals(3, toks.length, "Invalid line: " + line);
        return new Record(Action.valueOf(toks[0]), Paths.get(toks[1], new String[0]), new Long(toks[2]));
    }

    private Record(Action action, Path path, Long checksum) {
        IllegalArgumentAssertion.assertNotNull(action, "action");
        IllegalArgumentAssertion.assertNotNull(path, "path");
        IllegalArgumentAssertion.assertNotNull(checksum, "checksum");
        this.action = action;
        this.path = path;
        this.checksum = checksum;
    }

    public Action getAction() {
        return this.action;
    }

    public Path getPath() {
        return this.path;
    }

    public Long getChecksum() {
        return this.checksum;
    }

    public int hashCode() {
        return ("" + this.path + this.checksum).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record)obj;
        return this.path.equals(other.path) && this.checksum.equals(other.checksum);
    }

    public String toString() {
        return (Object)((Object)this.action) + " " + this.path + " " + this.checksum;
    }

    public static enum Action {
        INFO,
        ADD,
        UPD,
        DEL;

    }
}

