/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.Record;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.Version;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

final class Parser {
    static Version VERSION;
    static final String VERSION_PREFIX = "# fusepatch:";
    static final String PATCHID_PREFIX = "# patch id:";

    Parser() {
    }

    static Package buildPackageFromZip(PatchId patchId, Record.Action action, File zipfile) throws IOException {
        IllegalArgumentAssertion.assertNotNull(zipfile, "zipfile");
        IllegalArgumentAssertion.assertTrue(zipfile.isFile(), "Zip file does not exist: " + zipfile);
        HashSet<Record> records = new HashSet<Record>();
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(zipfile));){
            byte[] buffer = new byte[1024];
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String name = entry.getName();
                    int read = zip.read(buffer);
                    while (read > 0) {
                        read = zip.read(buffer);
                    }
                    long crc = entry.getCrc();
                    records.add(Record.create(action, Paths.get(name, new String[0]), crc));
                }
                entry = zip.getNextEntry();
            }
        }
        return Package.create(patchId, records);
    }

    static Package readPackage(Path rootPath, PatchId patchId) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        return Parser.readPackage(Parser.assertMetadataFile(rootPath, patchId));
    }

    static List<PatchId> getAvailable(Path rootPath, final String prefix, boolean latest) {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        final HashMap auxmap = new HashMap();
        if (rootPath.toFile().exists()) {
            try {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        String name = path.getFileName().toString();
                        if ((prefix == null || name.startsWith(prefix)) && name.endsWith(".metadata")) {
                            PatchId patchId = PatchId.fromFile(path.toFile());
                            TreeSet<PatchId> idset = (TreeSet<PatchId>)auxmap.get(patchId.getName());
                            if (idset == null) {
                                idset = new TreeSet<PatchId>();
                                auxmap.put(patchId.getName(), idset);
                            }
                            idset.add(patchId);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        TreeSet sortedSet = new TreeSet();
        for (TreeSet set : auxmap.values()) {
            if (latest) {
                sortedSet.add(set.last());
                continue;
            }
            sortedSet.addAll(set);
        }
        ArrayList result = new ArrayList(sortedSet);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    static void writeAuditLog(Path rootPath, String message, SmartPatch smartPatch) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(message, "message");
        IllegalArgumentAssertion.assertNotNull(smartPatch, "smartPatch");
        try (FileOutputStream fos = new FileOutputStream(rootPath.resolve("audit.log").toFile(), true);){
            PrintStream pw = new PrintStream(fos);
            pw.println();
            String date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date());
            pw.println("# " + date);
            pw.println("# " + message);
            Package patchSet = Package.create(smartPatch.getPatchId(), smartPatch.getRecords(), smartPatch.getPostCommands());
            Parser.writePackage(patchSet, fos, false);
        }
    }

    static List<String> readAuditLog(Path rootPath) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        ArrayList<String> lines = new ArrayList<String>();
        File auditFile = rootPath.resolve("audit.log").toFile();
        if (auditFile.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(auditFile));){
                String line = br.readLine();
                while (line != null) {
                    lines.add(line);
                    line = br.readLine();
                }
            }
        }
        return Collections.unmodifiableList(lines);
    }

    static void writePackage(Path rootPath, Package patchSet) throws IOException {
        IllegalArgumentAssertion.assertNotNull(rootPath, "rootPath");
        IllegalArgumentAssertion.assertNotNull(patchSet, "patchSet");
        File metadataFile = Parser.getMetadataFile(rootPath, patchSet.getPatchId());
        metadataFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(metadataFile);){
            Parser.writePackage(patchSet, fos, true);
        }
    }

    static void writePackage(Package patchSet, OutputStream outstream) throws IOException {
        Parser.writePackage(patchSet, outstream, true);
    }

    static File getMetadataFile(Path rootPath, PatchId patchId) {
        return rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString(), patchId + ".metadata")).toFile();
    }

    static File assertMetadataFile(Path rootPath, PatchId patchId) {
        File metadataFile = Parser.getMetadataFile(rootPath, patchId);
        IllegalStateAssertion.assertTrue(metadataFile.isFile(), "Cannot obtain metadata file: " + metadataFile);
        return metadataFile;
    }

    private static void writePackage(Package patchSet, OutputStream outstream, boolean versions) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchSet, "patchSet");
        IllegalArgumentAssertion.assertNotNull(outstream, "outstream");
        try (PrintStream pw = new PrintStream(outstream);){
            Set<PatchId> deps;
            if (versions) {
                pw.println("# fusepatch: " + VERSION);
                pw.println("# patch id: " + patchSet.getPatchId());
            }
            if (!(deps = patchSet.getDependencies()).isEmpty()) {
                pw.println();
                pw.println("[properties]");
                Object spec = deps.toString();
                spec = ((String)spec).substring(1, ((String)spec).length() - 1);
                pw.println("Dependencies: " + (String)spec);
            }
            pw.println();
            pw.println("[content]");
            for (Record rec : patchSet.getRecords()) {
                pw.println(rec.toString());
            }
            List<String> commands = patchSet.getPostCommands();
            if (!commands.isEmpty()) {
                pw.println();
                pw.println("[post-install-commands]");
                for (String cmd : commands) {
                    pw.println(cmd);
                }
            }
        }
    }

    static Package readPackage(File metadataFile) throws IOException {
        IllegalArgumentAssertion.assertNotNull(metadataFile, "metadataFile");
        IllegalArgumentAssertion.assertTrue(metadataFile.isFile(), "Cannot find metadata file: " + metadataFile);
        HashSet<Record> records = new HashSet<Record>();
        ArrayList<String> commands = new ArrayList<String>();
        LinkedHashSet<PatchId> dependencies = new LinkedHashSet<PatchId>();
        try (BufferedReader br = new BufferedReader(new FileReader(metadataFile));){
            String line = br.readLine().trim();
            IllegalStateAssertion.assertTrue(line.startsWith(VERSION_PREFIX), "Cannot obtain version info");
            line = br.readLine().trim();
            IllegalStateAssertion.assertTrue(line.startsWith(PATCHID_PREFIX), "Cannot obtain patch id");
            PatchId patchId = PatchId.fromString(line.substring(PATCHID_PREFIX.length()).trim());
            String mode = null;
            while (line != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) {
                    line = br.readLine();
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("]")) {
                    mode = line;
                    line = br.readLine();
                    continue;
                }
                if ("[properties]".equals(mode)) {
                    String[] toks = line.split(":");
                    IllegalStateAssertion.assertEquals(2, toks.length, "Illegal property spec: " + line);
                    String name = toks[0].trim();
                    String value = toks[1].trim();
                    if ("Dependencies".equals(name)) {
                        IllegalStateAssertion.assertTrue(dependencies.isEmpty(), "Dependencies already defined" + line);
                        for (String tok : value.split(",")) {
                            dependencies.add(PatchId.fromString(tok.trim()));
                        }
                    }
                }
                if ("[content]".equals(mode)) {
                    records.add(Record.fromString(line));
                }
                if ("[post-install-commands]".equals(mode)) {
                    commands.add(line);
                }
                line = br.readLine();
            }
            Package package_ = Package.create(patchId, records, dependencies, commands);
            return package_;
        }
    }

    static {
        try (InputStream input = SmartPatch.class.getResourceAsStream("version.properties");){
            BufferedReader br = new BufferedReader(new InputStreamReader(input));
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    VERSION = Version.parseVersion(line);
                    break;
                }
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

