/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.wildfly.extras.patch.Package;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.SmartPatch;
import org.wildfly.extras.patch.internal.DefaultRepository;
import org.wildfly.extras.patch.internal.Lock;
import org.wildfly.extras.patch.internal.WildFlyServer;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public final class DefaultPatchTool
extends PatchTool {
    private Server server;
    private Repository repository;
    private Path serverPath;
    private URL repoUrl;

    public DefaultPatchTool(Path serverPath, URL repoUrl) {
        this.serverPath = serverPath;
        this.repoUrl = repoUrl;
    }

    @Override
    public Server getServer() {
        if (this.server == null) {
            this.server = new WildFlyServer(this.serverPath);
        }
        return this.server;
    }

    @Override
    public Repository getRepository() {
        if (this.repository == null) {
            if (this.repoUrl == null) {
                this.repoUrl = DefaultRepository.getConfiguredUrl();
                if (this.repoUrl == null) {
                    try {
                        this.repoUrl = this.getServer().getDefaultRepositoryPath().toUri().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            }
            this.repository = new DefaultRepository(this.repoUrl);
        }
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package install(PatchId patchId, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package package_ = this.installInternal(patchId, force);
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package update(String prefix, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(prefix, "prefix");
        Lock.tryLock();
        try {
            PatchId latestId = this.getRepository().getLatestAvailable(prefix);
            PatchAssertion.assertNotNull(latestId, "Cannot obtain patch id for prefix: " + prefix);
            Package package_ = this.installInternal(latestId, force);
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package uninstall(PatchId patchId, boolean force) throws IOException {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        Lock.tryLock();
        try {
            Package installed = this.getServer().getPackage(patchId);
            PatchAssertion.assertNotNull(installed, "Package not installed: " + patchId);
            PatchId latestId = this.getServer().getPackage(patchId.getName()).getPatchId();
            PatchAssertion.assertEquals(patchId, latestId, "Active package is " + latestId + ", cannot uninstall: " + patchId);
            SmartPatch smartPatch = SmartPatch.forUninstall(installed);
            Package package_ = this.getServer().applySmartPatch(smartPatch, force);
            return package_;
        }
        finally {
            Lock.unlock();
        }
    }

    private Package installInternal(PatchId patchId, boolean force) throws IOException {
        PatchId serverId = null;
        String prefix = patchId.getName();
        for (PatchId pid : this.getServer().queryAppliedPackages()) {
            if (!pid.getName().equals(prefix)) continue;
            serverId = pid;
            break;
        }
        Package seedPatch = serverId != null ? this.getServer().getPackage(serverId) : null;
        SmartPatch smartPatch = this.getRepository().getSmartPatch(seedPatch, patchId);
        return this.getServer().applySmartPatch(smartPatch, force);
    }

    public String toString() {
        return "DefaultPatchTool[server=" + this.serverPath + ",repo=" + this.repoUrl + "]";
    }
}

