/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.wildfly.extras.patch.Configuration;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.Repository;
import org.wildfly.extras.patch.Server;
import org.wildfly.extras.patch.aether.AetherFactory;
import org.wildfly.extras.patch.internal.DefaultPatchTool;
import org.wildfly.extras.patch.repository.AetherRepository;
import org.wildfly.extras.patch.repository.LocalFileRepository;
import org.wildfly.extras.patch.repository.RepositoryClient;
import org.wildfly.extras.patch.server.ServerFactory;
import org.wildfly.extras.patch.server.WildFlyServer;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public final class PatchToolBuilder {
    private ReentrantLock lock = new ReentrantLock();
    private URL repoUrl;
    private Path serverPath;
    private ServerFactory serverFactory;
    private AetherFactory aetherFactory;
    private String username;
    private String password;

    public PatchToolBuilder loadConfiguration(URL configUrl) throws IOException {
        IllegalArgumentAssertion.assertNotNull(configUrl, "configUrl");
        Configuration config = Configuration.load(configUrl);
        config.loadPatchToolBuilder(this);
        return this;
    }

    public PatchToolBuilder customLock(ReentrantLock lock) {
        this.lock = lock;
        return this;
    }

    public PatchToolBuilder serverPath(Path serverPath) {
        this.serverPath = serverPath;
        return this;
    }

    public PatchToolBuilder repositoryURL(URL repoUrl) {
        IllegalArgumentAssertion.assertNotNull(repoUrl, "repoUrl");
        this.repoUrl = repoUrl;
        return this;
    }

    public PatchToolBuilder aetherFactory(AetherFactory aetherFactory) {
        IllegalArgumentAssertion.assertNotNull(aetherFactory, "aetherFactory");
        this.aetherFactory = aetherFactory;
        return this;
    }

    public PatchToolBuilder targetServer(ServerFactory serverFactory) {
        IllegalArgumentAssertion.assertNotNull(serverFactory, "serverFactory");
        this.serverFactory = serverFactory;
        return this;
    }

    public PatchToolBuilder credentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public PatchTool build() {
        return new DefaultPatchTool(this.lock, this.buildServer(), this.buildRepository());
    }

    private Server buildServer() {
        Server server = null;
        if (this.serverFactory != null) {
            server = this.serverFactory.getServer();
        } else if (this.serverPath != null) {
            server = new WildFlyServer(this.lock, this.serverPath);
        }
        return server;
    }

    private Repository buildRepository() {
        Repository repository = null;
        if (this.aetherFactory != null) {
            repository = new AetherRepository((Lock)this.lock, this.aetherFactory);
        } else if (this.repoUrl != null) {
            String protocol = this.repoUrl.getProtocol();
            if (protocol.startsWith("http")) {
                repository = new RepositoryClient(this.lock, this.repoUrl, this.username, this.password);
            }
            if (protocol.equals("file")) {
                Path rootPath = this.getAbsolutePath(this.repoUrl);
                repository = new LocalFileRepository((Lock)this.lock, rootPath);
            }
            IllegalStateAssertion.assertNotNull(repository, "Unsupported protocol: " + protocol);
        }
        return repository;
    }

    private Path getAbsolutePath(URL url) {
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsoluteFile().toPath();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

