/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.config.internal;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.wildfly.extras.config.ConfigException;
import org.wildfly.extras.config.ConfigLogger;
import org.wildfly.extras.config.ConfigSupport;
import org.wildfly.extras.config.internal.Options;

public class Main {
    public static void main(String[] args) {
        try {
            Main.mainInternal(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void mainInternal(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            Main.helpScreen(parser);
            return;
        }
        try {
            ArrayList<String> configs = new ArrayList<String>();
            if (options.configs != null) {
                configs.addAll(Arrays.asList(options.configs.split(",")));
            }
            ConfigSupport.applyConfigChange(ConfigSupport.getJBossHome(), configs, options.enable);
        }
        catch (ConfigException ex) {
            ConfigLogger.error(ex);
            throw ex;
        }
        catch (Throwable th) {
            ConfigLogger.error(th);
            throw th;
        }
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        ConfigLogger.error("fuseconfig [options...]");
        cmdParser.printUsage((OutputStream)System.err);
    }
}

