/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.Patch;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.internal.Main;
import org.wildfly.extras.patch.internal.MetadataParser;
import org.wildfly.extras.patch.repository.AbstractRepository;
import org.wildfly.extras.patch.utils.IOUtils;
import org.wildfly.extras.patch.utils.IllegalArgumentAssertion;
import org.wildfly.extras.patch.utils.PatchAssertion;

public final class LocalFileRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileRepository.class);
    private final Path rootPath;

    public LocalFileRepository(Lock lock, Path rootPath) {
        super(lock, LocalFileRepository.toRepositoryUrl(rootPath));
        this.rootPath = rootPath;
        PatchAssertion.assertTrue(rootPath.toFile().isDirectory(), "Repository root does not exist: " + rootPath);
        LOG.debug("Repository location: {}", (Object)rootPath);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static URL getDefaultRepositoryURL() {
        String repoSpec = System.getProperty("fusepatch.repository");
        if (repoSpec == null) {
            repoSpec = System.getenv("FUSEPATCH_REPOSITORY");
        }
        if (repoSpec == null) {
            URL codeLocation;
            CodeSource codeSource = Main.class.getProtectionDomain().getCodeSource();
            URL uRL = codeLocation = codeSource != null ? codeSource.getLocation() : null;
            if (codeLocation != null) {
                String modulePath = "modules/system/layers/fuse/org/wildfly/extras/patch";
                if (codeLocation.getPath().contains(modulePath)) {
                    Path jbossHome = Paths.get(codeLocation.getPath().substring(0, codeLocation.getPath().indexOf(modulePath)), new String[0]);
                    Path repositoryPath = jbossHome.resolve("fusepatch").resolve("repository");
                    repoSpec = repositoryPath.toString();
                }
            }
        }
        URL repoUrl = null;
        if (repoSpec != null) {
            try {
                repoUrl = new URL(repoSpec);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return repoUrl;
    }

    @Override
    public List<PatchId> queryAvailable(String prefix) {
        this.lock.tryLock();
        try {
            List<PatchId> list = MetadataParser.queryAvailablePatches(this.rootPath, prefix, false);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Patch getPatch(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            Patch patch = MetadataParser.readPatch(this.rootPath, patchId);
            return patch;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public PatchId addArchive(PatchMetadata metadata, DataHandler dataHandler, boolean force) throws IOException {
        URL sourceURL;
        Path sourcePath;
        PatchId result = super.addArchive(metadata, dataHandler, force);
        if (dataHandler.getDataSource() instanceof URLDataSource && (sourcePath = new File((sourceURL = ((URLDataSource)dataHandler.getDataSource()).getURL()).getPath()).toPath()).startsWith(this.rootPath)) {
            File sourceFile = sourcePath.toFile();
            File targetFile = new File(sourceFile.getPath().concat(".delete"));
            sourceFile.renameTo(targetFile);
            targetFile.delete();
        }
        return result;
    }

    @Override
    protected PatchId addArchiveInternal(Patch patch, DataHandler dataHandler) throws IOException {
        PatchId patchId = patch.getPatchId();
        Path targetPath = this.getPatchPath(patchId);
        File targetFile = targetPath.toFile();
        targetFile.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(targetFile);){
            IOUtils.copy(dataHandler.getInputStream(), output);
        }
        MetadataParser.writePatch(this.rootPath, patch);
        return patchId;
    }

    @Override
    public boolean removeArchive(PatchId patchId) {
        IllegalArgumentAssertion.assertNotNull(patchId, "patchId");
        this.lock.tryLock();
        try {
            File patchdir = MetadataParser.getMetadataDirectory(this.rootPath, patchId);
            PatchAssertion.assertTrue(patchdir.isDirectory(), "Archive does not exist: " + patchId);
            IOUtils.rmdirs(patchdir.toPath());
            LOG.info("Removed {}", (Object)patchId);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected DataSource getDataSource(PatchId patchId) {
        Path patchPath = this.getPatchPath(patchId);
        return new FileDataSource(patchPath.toFile());
    }

    private static URL toRepositoryUrl(Path rootPath) {
        try {
            return rootPath.toUri().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private Path getPatchPath(PatchId patchId) {
        return this.rootPath.resolve(Paths.get(patchId.getName(), patchId.getVersion().toString(), patchId + ".zip"));
    }

    public String toString() {
        return "LocalFileRepository[rootPath=" + this.rootPath + "]";
    }
}

