/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.patch.ManagedPath;
import org.wildfly.extras.patch.PatchException;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;
import org.wildfly.extras.patch.PatchMetadataBuilder;
import org.wildfly.extras.patch.PatchTool;
import org.wildfly.extras.patch.PatchToolBuilder;
import org.wildfly.extras.patch.internal.Options;
import org.wildfly.extras.patch.internal.PatchMetadataModel;
import org.wildfly.extras.patch.repository.LocalFileRepository;
import org.wildfly.extras.patch.utils.IllegalStateAssertion;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        try {
            Main.mainInternal(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public static void mainInternal(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            Main.helpScreen(parser);
            throw ex;
        }
        try {
            Main.run(parser, options);
        }
        catch (PatchException ex) {
            LOG.error("ERROR {}", (Object)ex.getMessage());
            LOG.debug("Patch Exception", (Throwable)ex);
            throw ex;
        }
        catch (Throwable th) {
            LOG.error("Error executing command", th);
            throw th;
        }
    }

    private static void run(CmdLineParser cmdParser, Options options) throws IOException, JAXBException {
        PatchTool patchTool;
        PatchToolBuilder builder = new PatchToolBuilder();
        URL defaultRepoURL = LocalFileRepository.getDefaultRepositoryURL();
        if (defaultRepoURL != null) {
            builder.repositoryURL(defaultRepoURL);
        }
        if (options.configUrl != null) {
            builder.loadConfiguration(options.configUrl);
        }
        if (options.repositoryUrl != null) {
            builder.repositoryURL(options.repositoryUrl);
        }
        if (options.serverHome != null) {
            builder.serverPath(options.serverHome);
        }
        boolean opfound = false;
        if (options.queryRepository) {
            patchTool = builder.build();
            Main.printPatches(patchTool.getRepository().queryAvailable(null));
            opfound = true;
        }
        if (options.queryServer) {
            patchTool = builder.serverPath(options.serverHome).build();
            Main.printPatches(patchTool.getServer().queryAppliedPatches());
            opfound = true;
        }
        if (options.queryServerPaths != null) {
            patchTool = builder.serverPath(options.serverHome).build();
            ArrayList<String> managedPaths = new ArrayList<String>();
            for (ManagedPath managedPath : patchTool.getServer().queryManagedPaths(options.queryServerPaths)) {
                managedPaths.add(managedPath.toString());
            }
            Main.printLines(managedPaths);
            opfound = true;
        }
        if (options.addUrl != null) {
            Main.addArchive(builder.build(), options);
            opfound = true;
        }
        if (options.removeId != null) {
            patchTool = builder.build();
            patchTool.getRepository().removeArchive(PatchId.fromString(options.removeId));
            opfound = true;
        }
        if (options.installId != null) {
            patchTool = builder.serverPath(options.serverHome).build();
            patchTool.getServer().cleanUp();
            patchTool.install(PatchId.fromString(options.installId), options.force);
            opfound = true;
        }
        if (options.updateName != null) {
            patchTool = builder.serverPath(options.serverHome).build();
            patchTool.getServer().cleanUp();
            patchTool.update(options.updateName, options.force);
            opfound = true;
        }
        if (options.uninstallId != null) {
            patchTool = builder.serverPath(options.serverHome).build();
            patchTool.getServer().cleanUp();
            patchTool.uninstall(PatchId.fromString(options.uninstallId));
            opfound = true;
        }
        if (options.auditLog) {
            patchTool = builder.serverPath(options.serverHome).build();
            Main.printLines(patchTool.getServer().getAuditLog());
            opfound = true;
        }
        if (!opfound) {
            Main.helpScreen(cmdParser);
        }
    }

    private static void addArchive(PatchTool patchTool, Options options) throws IOException, JAXBException {
        PatchId patchId = PatchId.fromURL(options.addUrl);
        PatchMetadataBuilder mdbuilder = new PatchMetadataBuilder().patchId(patchId);
        if (options.metadataUrl != null) {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{PatchMetadataModel.class}).createUnmarshaller();
            PatchMetadataModel model = (PatchMetadataModel)unmarshaller.unmarshal(options.metadataUrl);
            PatchMetadata auxmd = model.toPatchMetadata();
            mdbuilder = new PatchMetadataBuilder().patchId(auxmd.getPatchId());
            mdbuilder.oneoffId(auxmd.getOneoffId());
            mdbuilder.dependencies(auxmd.getDependencies());
            mdbuilder.postCommands(auxmd.getPostCommands());
        }
        PatchMetadata metadata = mdbuilder.build();
        if (options.oneoffId != null) {
            IllegalStateAssertion.assertNull(metadata.getOneoffId(), "One-Off patch id already defined: " + metadata);
            PatchId oneoffId = PatchId.fromString(options.oneoffId);
            mdbuilder.oneoffId(oneoffId);
        }
        if (options.dependencies != null) {
            IllegalStateAssertion.assertTrue(metadata.getDependencies().isEmpty(), "Dependencies already defined: " + metadata);
            LinkedHashSet<PatchId> dependencies = new LinkedHashSet<PatchId>();
            for (String depid : options.dependencies) {
                dependencies.add(PatchId.fromString(depid));
            }
            mdbuilder.dependencies(dependencies);
        }
        if (options.roles != null) {
            IllegalStateAssertion.assertTrue(metadata.getRoles().isEmpty(), "Roles already defined: " + metadata);
            mdbuilder.roles(options.roles);
        }
        if (options.addCmd != null) {
            IllegalStateAssertion.assertTrue(metadata.getPostCommands().isEmpty(), "Post commands already defined: " + metadata);
            mdbuilder.postCommands(options.addCmd);
        }
        DataHandler dataHandler = new DataHandler((DataSource)new URLDataSource(options.addUrl));
        patchTool.getRepository().addArchive(mdbuilder.build(), dataHandler, options.force);
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        System.err.println("fusepatch [options...]");
        cmdParser.printUsage((OutputStream)System.err);
    }

    private static void printLines(List<String> lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    private static void printPatches(List<PatchId> patches) {
        for (PatchId patchId : patches) {
            System.out.println(patchId.toString());
        }
    }
}

