/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.IOException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import software.amazon.awssdk.services.ec2.model.Instance;
import sunstone.annotation.DomainMode;
import sunstone.annotation.OperatingMode;
import sunstone.annotation.StandaloneMode;
import sunstone.annotation.WildFly;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsWFIdentifiableSunstoneResource;
import sunstone.core.CreaperUtils;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;
import sunstone.inject.Hostname;

public class AwsWFIdentifiableSunstoneResourceUtils {
    static Hostname resolveHostname(AwsWFIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        switch (identification.type) {
            case EC2_INSTANCE: {
                Instance ec2 = identification.get(store, Instance.class);
                return () -> ((Instance)ec2).publicIpAddress();
            }
        }
        throw new UnsupportedSunstoneOperationException("Unsupported type for getting hostname: " + (Object)((Object)identification.type));
    }

    static OnlineManagementClient resolveOnlineManagementClient(AwsWFIdentifiableSunstoneResource.Identification identification, WildFly wildfly, AwsSunstoneStore store) throws SunstoneException {
        try {
            if (identification.type == AwsWFIdentifiableSunstoneResource.EC2_INSTANCE) {
                if (wildfly.mode() == OperatingMode.STANDALONE) {
                    return CreaperUtils.createStandaloneManagementClient((String)AwsWFIdentifiableSunstoneResourceUtils.resolveHostname(identification, store).get(), (StandaloneMode)wildfly.standalone());
                }
                if (wildfly.mode() == OperatingMode.DOMAIN) {
                    return CreaperUtils.createDomainManagementClient((String)AwsWFIdentifiableSunstoneResourceUtils.resolveHostname(identification, store).get(), (DomainMode)wildfly.domain());
                }
                throw new UnsupportedSunstoneOperationException("Unknown operating mode specified for injecting OnlineManagementClient.");
            }
            throw new UnsupportedSunstoneOperationException("Only AWS EC2 instance is supported for injecting OnlineManagementClient.");
        }
        catch (IOException e) {
            throw new SunstoneException((Throwable)e);
        }
    }
}

