/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.aws.annotation.AwsAutoResolve;
import sunstone.aws.annotation.AwsEc2Instance;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

enum AwsWFIdentifiableSunstoneResource {
    UNSUPPORTED(null),
    AUTO((Class)AwsAutoResolve.class){
        final Class<?>[] supportedTypesForInjection = new Class[0];

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return (T)AwsIdentifiableSunstoneResource.AUTO.get(injectionAnnotation, store, clazz);
        }
    }
    ,
    EC2_INSTANCE((Class)AwsEc2Instance.class){
        final Class<?>[] supportedTypesForInjection = new Class[]{OnlineManagementClient.class};

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        boolean deployToWildFlySupported() {
            return true;
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return (T)AwsIdentifiableSunstoneResource.EC2_INSTANCE.get(injectionAnnotation, store, clazz);
        }
    };

    private final Class<?> representedInjectionAnnotation;

    Class<?> getRepresentedInjectionAnnotation() {
        return this.representedInjectionAnnotation;
    }

    private AwsWFIdentifiableSunstoneResource(Class<?> representedInjectionAnnotation) {
        this.representedInjectionAnnotation = representedInjectionAnnotation;
    }

    public String toString() {
        if (this.representedInjectionAnnotation == null) {
            return "unsupported AwsIdentifiableSunstoneResource type";
        }
        return String.format("%s representing %s injection annotation", this.name(), this.representedInjectionAnnotation.getName());
    }

    boolean isTypeSupportedForInject(Class<?> type) {
        return false;
    }

    boolean deployToWildFlySupported() {
        return false;
    }

    <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
        throw new UnsupportedSunstoneOperationException(String.format("%s annotation is not supported for the type %s", injectionAnnotation.annotationType().getName(), this.toString()));
    }

    public static boolean isSupported(Annotation annotation) {
        return AwsWFIdentifiableSunstoneResource.getType(annotation) != UNSUPPORTED;
    }

    public static AwsWFIdentifiableSunstoneResource getType(Annotation annotation) {
        if (AwsEc2Instance.class.isAssignableFrom(annotation.annotationType())) {
            return EC2_INSTANCE;
        }
        if (AwsAutoResolve.class.isAssignableFrom(annotation.annotationType())) {
            return AUTO;
        }
        return UNSUPPORTED;
    }

    static class Identification {
        final Annotation identification;
        final AwsWFIdentifiableSunstoneResource type;

        Identification(Annotation annotation) {
            this.type = AwsWFIdentifiableSunstoneResource.getType(annotation);
            this.identification = annotation;
        }

        <T> T get(AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return this.type.get(this.identification, store, clazz);
        }
    }
}

