/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import sunstone.annotation.WildFly;
import sunstone.aws.annotation.AwsResourceIdentificationAnnotation;
import sunstone.aws.impl.AwsWFArchiveDeployer;
import sunstone.aws.impl.AwsWFIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsWFLogger;
import sunstone.core.AnnotationUtils;
import sunstone.core.api.SunstoneArchiveDeployer;
import sunstone.core.spi.SunstoneArchiveDeployerProvider;

public class AwsWFArchiveDeployerProvider
implements SunstoneArchiveDeployerProvider {
    public Optional<SunstoneArchiveDeployer> create(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        List resourceIdentifications = AnnotationUtils.findAnnotationsAnnotatedBy((Annotation[])methodAnnotations, AwsResourceIdentificationAnnotation.class);
        if (resourceIdentifications.isEmpty()) {
            return Optional.empty();
        }
        Optional wildFly = AnnotationUtils.getAnnotation((Annotation[])methodAnnotations, WildFly.class);
        AwsWFIdentifiableSunstoneResource.Identification identification = new AwsWFIdentifiableSunstoneResource.Identification((Annotation)resourceIdentifications.get(0));
        if (identification.type != AwsWFIdentifiableSunstoneResource.UNSUPPORTED && identification.type.deployToWildFlySupported()) {
            if (resourceIdentifications.size() > 1) {
                AwsWFLogger.DEFAULT.warn(String.format("Deployment method %s is supposed to be annotated only by one annotation identifying a cloud resource. %s is accepted.", method, ((Annotation)resourceIdentifications.get(0)).toString()));
            }
            if (!wildFly.isPresent()) {
                AwsWFLogger.DEFAULT.info(String.format("%s is missing %s, sunstone azure-wildfly is going with standalone defaults. ", method, WildFly.class));
            }
            return Optional.of(new AwsWFArchiveDeployer(identification, (WildFly)wildFly.orElse(new WildFly.WildFlyDefault())));
        }
        return Optional.empty();
    }
}

