/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import sunstone.annotation.WildFly;
import sunstone.aws.annotation.AwsResourceIdentificationAnnotation;
import sunstone.aws.impl.AwsLogger;
import sunstone.aws.impl.AwsWFIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsWFLogger;
import sunstone.aws.impl.AwsWFSunstoneResourceInjector;
import sunstone.core.AnnotationUtils;
import sunstone.core.api.SunstoneResourceInjector;
import sunstone.core.spi.SunstoneResourceInjectorProvider;

public class AwsWFSunstoneResourceInjectorProvider
implements SunstoneResourceInjectorProvider {
    public Optional<SunstoneResourceInjector> create(Field field) {
        Annotation[] fieldAnnotations = field.getAnnotations();
        List resourceIdentifications = AnnotationUtils.findAnnotationsAnnotatedBy((Annotation[])field.getAnnotations(), AwsResourceIdentificationAnnotation.class);
        if (resourceIdentifications.isEmpty()) {
            return Optional.empty();
        }
        Optional wildFly = AnnotationUtils.getAnnotation((Annotation[])fieldAnnotations, WildFly.class);
        if (resourceIdentifications.size() > 1) {
            AwsLogger.DEFAULT.warn(String.format("Injected field %s is supposed to be annotated only by one annotation identifying a cloud resource. %s is accepted.", field, ((Annotation)resourceIdentifications.get(0)).toString()));
        }
        AwsWFIdentifiableSunstoneResource.Identification identification = new AwsWFIdentifiableSunstoneResource.Identification((Annotation)resourceIdentifications.get(0));
        if (!wildFly.isPresent()) {
            AwsWFLogger.DEFAULT.info(String.format("%s is missing %s annotation, sunstone azure-wildfly is going with standalone defaults", field, WildFly.class));
        }
        if (identification.type != AwsWFIdentifiableSunstoneResource.UNSUPPORTED && identification.type.isTypeSupportedForInject(field.getType())) {
            return Optional.of(new AwsWFSunstoneResourceInjector(identification, (WildFly)wildFly.orElse(new WildFly.WildFlyDefault()), field.getType()));
        }
        return Optional.empty();
    }
}

