/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.StringUtils;
import org.wildfly.extras.creaper.commands.deployments.Deploy;
import org.wildfly.extras.creaper.commands.deployments.Undeploy;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.annotation.DomainMode;
import sunstone.annotation.WildFly;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsWFIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsWFIdentifiableSunstoneResourceUtils;
import sunstone.core.CreaperUtils;
import sunstone.core.api.SunstoneArchiveDeployer;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

public class AwsWFArchiveDeployer
implements SunstoneArchiveDeployer {
    private final AwsWFIdentifiableSunstoneResource.Identification identification;
    private WildFly wildFly;

    AwsWFArchiveDeployer(AwsWFIdentifiableSunstoneResource.Identification identification, WildFly wildFly) {
        this.identification = identification;
        this.wildFly = wildFly;
    }

    static void undeployFromEc2Instance(String deploymentName, AwsWFIdentifiableSunstoneResource.Identification resourceIdentification, WildFly wildFly, AwsSunstoneStore store) throws SunstoneException {
        try (OnlineManagementClient client = AwsWFIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(resourceIdentification, wildFly, store);){
            client.apply(new OnlineCommand[]{new Undeploy.Builder(deploymentName).build()});
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void deployToEc2Instance(String deploymentName, AwsWFIdentifiableSunstoneResource.Identification resourceIdentification, WildFly wildFly, InputStream is, AwsSunstoneStore store) throws SunstoneException {
        Deploy.Builder builder = new Deploy.Builder(is, deploymentName, true);
        DomainMode domainMode = wildFly.domain();
        if (domainMode != null) {
            CreaperUtils.setDomainServers((Deploy.Builder)builder, (DomainMode)domainMode);
        }
        try (OnlineManagementClient client = AwsWFIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(resourceIdentification, wildFly, store);){
            client.apply(new OnlineCommand[]{builder.build()});
        }
        catch (IOException | CommandFailedException e) {
            throw new SunstoneException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deploy(String deploymentName, Object object, ExtensionContext ctx) throws SunstoneException {
        InputStream is;
        AwsSunstoneStore store = AwsSunstoneStore.get((ExtensionContext)ctx);
        if (!this.identification.type.deployToWildFlySupported()) {
            throw new UnsupportedSunstoneOperationException(String.format("Unsupported target %s for deploy operation", new Object[]{this.identification.type}));
        }
        try {
            if (object instanceof Archive) {
                is = ((ZipExporter)((Archive)object).as(ZipExporter.class)).exportAsInputStream();
            } else if (object instanceof File) {
                is = new FileInputStream((File)object);
            } else if (object instanceof Path) {
                is = new FileInputStream(((Path)object).toFile());
            } else {
                if (!(object instanceof InputStream)) throw new UnsupportedSunstoneOperationException("Unsupported type for deployment operation");
                is = (InputStream)object;
            }
        }
        catch (FileNotFoundException e) {
            throw new SunstoneException((Throwable)e);
        }
        try {
            switch (this.identification.type) {
                case EC2_INSTANCE: {
                    if (StringUtils.isBlank((String)deploymentName)) {
                        throw new IllegalArgumentSunstoneException("Deployment name can not be empty for AWS EC2 instance.");
                    }
                    AwsWFArchiveDeployer.deployToEc2Instance(deploymentName, this.identification, this.wildFly, is, store);
                    return;
                }
                default: {
                    throw new UnsupportedSunstoneOperationException("Deployment operation is not supported for " + (Object)((Object)this.identification.type));
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new SunstoneException((Throwable)e);
                }
            }
        }
    }

    public void undeploy(String deploymentName, ExtensionContext ctx) throws SunstoneException {
        AwsSunstoneStore store = AwsSunstoneStore.get((ExtensionContext)ctx);
        switch (this.identification.type) {
            case EC2_INSTANCE: {
                if (StringUtils.isBlank((String)deploymentName)) {
                    throw new IllegalArgumentSunstoneException("Deployment name can not be empty for Azure virtual machine.");
                }
                AwsWFArchiveDeployer.undeployFromEc2Instance(deploymentName, this.identification, this.wildFly, store);
                break;
            }
            default: {
                throw new UnsupportedSunstoneOperationException(String.format("Unknown resource type for undeploy operation from %s", new Object[]{this.identification.type}));
            }
        }
    }
}

