/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.s3.S3Client;
import sunstone.annotation.inject.Hostname;
import sunstone.aws.annotation.AwsAutoResolve;
import sunstone.aws.annotation.AwsInjectionAnnotation;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsIdentifiableSunstoneResourceUtils;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsUtils;
import sunstone.core.AnnotationUtils;
import sunstone.core.SunstoneConfig;
import sunstone.core.api.SunstoneResourceInjector;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

public class AwsSunstoneResourceInjector
implements SunstoneResourceInjector {
    static Ec2Client resolveEc2ClientDI(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        if (identification.type != AwsIdentifiableSunstoneResource.AUTO) {
            throw new UnsupportedSunstoneOperationException("EC2 Client may be injected only with " + AwsIdentifiableSunstoneResource.AUTO);
        }
        AwsAutoResolve annotation = (AwsAutoResolve)identification.identification;
        Ec2Client client = AwsUtils.getEC2Client(annotation.region().isBlank() ? SunstoneConfig.getString((String)"sunstone.aws.region") : SunstoneConfig.resolveExpressionToString((String)annotation.region()));
        return client;
    }

    static S3Client resolveS3ClientDI(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        if (identification.type != AwsIdentifiableSunstoneResource.AUTO) {
            throw new UnsupportedSunstoneOperationException("EC2 Client may be injected only with " + AwsIdentifiableSunstoneResource.AUTO);
        }
        AwsAutoResolve annotation = (AwsAutoResolve)identification.identification;
        S3Client client = AwsUtils.getS3Client(annotation.region().isBlank() ? SunstoneConfig.getString((String)"sunstone.aws.region") : SunstoneConfig.resolveExpressionToString((String)annotation.region()));
        return client;
    }

    static boolean canInject(Field field) {
        return Arrays.stream(field.getAnnotations()).filter(ann -> AnnotationUtils.isAnnotatedBy(ann.annotationType(), AwsInjectionAnnotation.class)).filter(AwsIdentifiableSunstoneResource::isSupported).anyMatch(a -> AwsIdentifiableSunstoneResource.getType(a).isTypeSupportedForInject(field.getType()));
    }

    public Object getAndRegisterResource(Annotation annotation, Class<?> fieldType, ExtensionContext ctx) throws SunstoneException {
        Hostname injected = null;
        AwsSunstoneStore store = AwsSunstoneStore.get(ctx);
        AwsIdentifiableSunstoneResource.Identification identification = new AwsIdentifiableSunstoneResource.Identification(annotation);
        if (!identification.type.isTypeSupportedForInject(fieldType)) {
            throw new SunstoneException(String.format("%s is not supported for injection to %s", identification.identification.annotationType(), fieldType));
        }
        if (Hostname.class.isAssignableFrom(fieldType)) {
            injected = AwsIdentifiableSunstoneResourceUtils.resolveHostname(identification, store);
            Objects.requireNonNull(injected, "Unable to determine hostname.");
        } else if (Ec2Client.class.isAssignableFrom(fieldType)) {
            Ec2Client client = AwsSunstoneResourceInjector.resolveEc2ClientDI(identification, store);
            store.addClosable((AutoCloseable)client);
            injected = client;
            Objects.requireNonNull(injected, "Unable to determine AWS EC2 client.");
        } else if (S3Client.class.isAssignableFrom(fieldType)) {
            S3Client client = AwsSunstoneResourceInjector.resolveS3ClientDI(identification, store);
            store.addClosable((AutoCloseable)client);
            injected = client;
            Objects.requireNonNull(injected, "Unable to determine AWS S3 client.");
        } else if (OnlineManagementClient.class.isAssignableFrom(fieldType)) {
            OnlineManagementClient client = AwsIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(identification, store);
            Objects.requireNonNull(client, "Unable to determine management client.");
            store.addClosable((Closeable)client);
            injected = client;
        }
        return injected;
    }
}

