/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.StringUtils;
import org.wildfly.extras.creaper.commands.deployments.Deploy;
import org.wildfly.extras.creaper.commands.deployments.Undeploy;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsIdentifiableSunstoneResourceUtils;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.core.api.SunstoneArchiveDeployer;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

public class AwsArchiveDeployer
implements SunstoneArchiveDeployer {
    static void deployToEc2Instance(String deploymentName, AwsIdentifiableSunstoneResource.Identification resourceIdentification, InputStream is, AwsSunstoneStore store) throws SunstoneException {
        try {
            OnlineManagementClient client = AwsIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(resourceIdentification, store);
            client.apply(new OnlineCommand[]{new Deploy.Builder(is, deploymentName, true).build()});
            store.addClosable(() -> {
                client.apply(new OnlineCommand[]{new Undeploy.Builder(deploymentName).build()});
                client.close();
            });
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public void deployAndRegisterUndeploy(String deploymentName, Annotation targetAnnotation, InputStream deployment, ExtensionContext ctx) throws SunstoneException {
        AwsSunstoneStore store = AwsSunstoneStore.get(ctx);
        AwsIdentifiableSunstoneResource.Identification identification = new AwsIdentifiableSunstoneResource.Identification(targetAnnotation);
        if (!identification.type.deployToWildFlySupported()) {
            throw new UnsupportedSunstoneOperationException("todo");
        }
        switch (identification.type) {
            case EC2_INSTANCE: {
                if (StringUtils.isBlank((String)deploymentName)) {
                    throw new IllegalArgumentSunstoneException("Deployment name can not be empty for AWS EC2 instance.");
                }
                AwsArchiveDeployer.deployToEc2Instance(deploymentName, identification, deployment, store);
                break;
            }
            default: {
                throw new UnsupportedSunstoneOperationException("Deployment operation is not supported for " + (Object)((Object)identification.type));
            }
        }
    }
}

