/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.IOException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import software.amazon.awssdk.services.ec2.model.Instance;
import sunstone.annotation.OperatingMode;
import sunstone.annotation.StandaloneMode;
import sunstone.annotation.inject.Hostname;
import sunstone.aws.annotation.AwsEc2Instance;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.core.CreaperUtils;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

public class AwsIdentifiableSunstoneResourceUtils {
    static Hostname resolveHostname(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        switch (identification.type) {
            case EC2_INSTANCE: {
                Instance ec2 = identification.get(store, Instance.class);
                return () -> ((Instance)ec2).publicIpAddress();
            }
        }
        throw new UnsupportedSunstoneOperationException("Unsupported type for getting hostname: " + (Object)((Object)identification.type));
    }

    static OnlineManagementClient resolveOnlineManagementClient(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        try {
            if (identification.type == AwsIdentifiableSunstoneResource.EC2_INSTANCE) {
                AwsEc2Instance annotation = (AwsEc2Instance)identification.identification;
                if (annotation.mode() == OperatingMode.STANDALONE) {
                    return CreaperUtils.createStandaloneManagementClient((String)AwsIdentifiableSunstoneResourceUtils.resolveHostname(identification, store).get(), (StandaloneMode)annotation.standalone());
                }
                throw new UnsupportedSunstoneOperationException("Only standalone mode is supported for injecting OnlineManagementClient.");
            }
            throw new UnsupportedSunstoneOperationException("Only AWS EC2 instance is supported for injecting OnlineManagementClient.");
        }
        catch (IOException e) {
            throw new SunstoneException((Throwable)e);
        }
    }
}

