/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import sunstone.annotation.Parameter;
import sunstone.aws.annotation.WithAwsCfTemplate;
import sunstone.aws.annotation.WithAwsCfTemplateRepeatable;
import sunstone.aws.impl.AwsCloudFormationCloudDeploymentManager;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsUtils;
import sunstone.core.AbstractSunstoneCloudDeployer;
import sunstone.core.SunstoneConfig;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneException;

public class AwsSunstoneDeployer
extends AbstractSunstoneCloudDeployer {
    private Annotation annotation;

    AwsSunstoneDeployer(Annotation annotation) {
        this.annotation = annotation;
    }

    public void deployAndRegisterForUndeploy(ExtensionContext ctx) throws SunstoneException {
        this.verify(this.annotation);
        AwsSunstoneStore store = AwsSunstoneStore.get(ctx);
        if (WithAwsCfTemplate.class.isAssignableFrom(this.annotation.annotationType())) {
            this.deployCfTemplate((WithAwsCfTemplate)this.annotation, store);
        } else if (WithAwsCfTemplateRepeatable.class.isAssignableFrom(this.annotation.annotationType())) {
            for (WithAwsCfTemplate withAwsCfTemplate : ((WithAwsCfTemplateRepeatable)this.annotation).value()) {
                this.deployCfTemplate(withAwsCfTemplate, store);
            }
        }
    }

    private void deployCfTemplate(WithAwsCfTemplate awsTemplateDefinition, AwsSunstoneStore store) throws SunstoneException {
        AwsCloudFormationCloudDeploymentManager deploymentManager = store.getAwsCfDemploymentManagerOrCreate();
        try {
            String content = AwsSunstoneDeployer.getResourceContent((String)awsTemplateDefinition.template());
            Map parameters = AwsSunstoneDeployer.getParameters((Parameter[])awsTemplateDefinition.parameters());
            String region = SunstoneConfig.resolveExpressionToString((String)awsTemplateDefinition.region());
            if (region == null) {
                throw new IllegalArgumentSunstoneException("Region for AWS template is not defined. It must be specified either in the annotation or as Sunstone Config property.");
            }
            String md5sum = AwsSunstoneDeployer.sum((String)content);
            if (!awsTemplateDefinition.perSuite() || !store.suiteLevelDeploymentExists(md5sum)) {
                CloudFormationClient cfClient = store.getAwsCfClientOrCreate(region);
                String stack = deploymentManager.deployAndRegister(cfClient, content, parameters);
                if (awsTemplateDefinition.perSuite()) {
                    store.addSuiteLevelClosable(() -> deploymentManager.undeploy(stack));
                    store.addSuiteLevelDeployment(md5sum);
                } else {
                    store.addClosable(() -> deploymentManager.undeploy(stack));
                }
            }
        }
        catch (IOException e) {
            throw new SunstoneException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SunstoneException((Throwable)e);
        }
    }

    private void verify(Annotation clazz) throws IllegalArgumentSunstoneException {
        if (!AwsUtils.propertiesForAwsClientArePresent()) {
            throw new RuntimeException("Missing credentials for AWS.");
        }
        if (!WithAwsCfTemplate.class.isAssignableFrom(clazz.annotationType()) && !WithAwsCfTemplateRepeatable.class.isAssignableFrom(clazz.annotationType())) {
            throw new IllegalArgumentSunstoneException(String.format("AwsSunstoneDeployer expects %s or %s annotations", WithAwsCfTemplate.class, WithAwsCfTemplateRepeatable.class));
        }
    }
}

