/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import sunstone.aws.annotation.AwsAutoResolve;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsIdentifiableSunstoneResourceUtils;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsUtils;
import sunstone.core.SunstoneConfig;
import sunstone.core.api.SunstoneResourceInjector;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;
import sunstone.inject.Hostname;

public class AwsSunstoneResourceInjector
implements SunstoneResourceInjector {
    private AwsIdentifiableSunstoneResource.Identification identification;
    private Class<?> fieldType;

    public AwsSunstoneResourceInjector(AwsIdentifiableSunstoneResource.Identification identification, Class<?> fieldType) {
        this.identification = identification;
        this.fieldType = fieldType;
    }

    static Ec2Client resolveEc2ClientDI(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        if (identification.type != AwsIdentifiableSunstoneResource.AUTO) {
            throw new UnsupportedSunstoneOperationException("EC2 Client may be injected only with " + (Object)((Object)AwsIdentifiableSunstoneResource.AUTO));
        }
        AwsAutoResolve annotation = (AwsAutoResolve)identification.identification;
        Ec2Client client = AwsUtils.getEC2Client(SunstoneConfig.resolveExpressionToString((String)annotation.region()));
        return client;
    }

    static S3Client resolveS3ClientDI(AwsIdentifiableSunstoneResource.Identification identification, AwsSunstoneStore store) throws SunstoneException {
        if (identification.type != AwsIdentifiableSunstoneResource.AUTO) {
            throw new UnsupportedSunstoneOperationException("EC2 Client may be injected only with " + (Object)((Object)AwsIdentifiableSunstoneResource.AUTO));
        }
        AwsAutoResolve annotation = (AwsAutoResolve)identification.identification;
        S3Client client = AwsUtils.getS3Client(SunstoneConfig.resolveExpressionToString((String)annotation.region()));
        return client;
    }

    public Object getResource(ExtensionContext ctx) throws SunstoneException {
        Hostname injected = null;
        AwsSunstoneStore store = AwsSunstoneStore.get(ctx);
        if (!this.identification.type.isTypeSupportedForInject(this.fieldType)) {
            throw new SunstoneException(String.format("%s is not supported for injection to %s", this.identification.identification.annotationType(), this.fieldType));
        }
        if (Hostname.class.isAssignableFrom(this.fieldType)) {
            injected = AwsIdentifiableSunstoneResourceUtils.resolveHostname(this.identification, store);
            Objects.requireNonNull(injected, "Unable to determine hostname.");
        } else if (Instance.class.isAssignableFrom(this.fieldType)) {
            injected = this.identification.get(store, Instance.class);
            Objects.requireNonNull(injected, "Unable to get EC2 Instance obstraction object.");
        } else if (Ec2Client.class.isAssignableFrom(this.fieldType)) {
            Ec2Client client = AwsSunstoneResourceInjector.resolveEc2ClientDI(this.identification, store);
            injected = client;
            Objects.requireNonNull(injected, "Unable to determine AWS EC2 client.");
        } else if (S3Client.class.isAssignableFrom(this.fieldType)) {
            S3Client client = AwsSunstoneResourceInjector.resolveS3ClientDI(this.identification, store);
            injected = client;
            Objects.requireNonNull(injected, "Unable to determine AWS S3 client.");
        }
        return injected;
    }

    public void closeResource(Object obj) throws Exception {
        if (!Hostname.class.isAssignableFrom(obj.getClass()) && !Instance.class.isAssignableFrom(obj.getClass())) {
            if (SdkAutoCloseable.class.isAssignableFrom(obj.getClass())) {
                ((SdkAutoCloseable)obj).close();
            } else {
                throw new IllegalArgumentSunstoneException("Unknown type " + obj.getClass());
            }
        }
    }
}

