/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.OnFailure;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.waiters.CloudFormationWaiter;
import sunstone.aws.impl.AwsLogger;

class AwsCloudFormationCloudDeploymentManager
implements Closeable {
    static Logger LOGGER = AwsLogger.DEFAULT;
    private final Map<CloudFormationClient, Set<String>> client2stacks = new ConcurrentHashMap<CloudFormationClient, Set<String>>();
    private final Map<String, CloudFormationClient> stack2Client = new ConcurrentHashMap<String, CloudFormationClient>();

    AwsCloudFormationCloudDeploymentManager() {
    }

    String deploy(CloudFormationClient cfClient, String template, Map<String, String> parameters) {
        String stackName = "SunstoneStack-" + UUID.randomUUID().toString().substring(0, 5);
        CloudFormationWaiter waiter = cfClient.waiter();
        ArrayList cfParameters = new ArrayList();
        parameters.forEach((k, v) -> cfParameters.add((Parameter)Parameter.builder().parameterKey(k).parameterValue(v).build()));
        CreateStackRequest stackRequest = (CreateStackRequest)CreateStackRequest.builder().stackName(stackName).templateBody(template).parameters(cfParameters).onFailure(OnFailure.ROLLBACK).build();
        cfClient.createStack(stackRequest);
        DescribeStacksRequest stacksRequest = (DescribeStacksRequest)DescribeStacksRequest.builder().stackName(stackName).build();
        WaiterResponse waiterResponse = waiter.waitUntilStackCreateComplete(stacksRequest);
        LOGGER.debug("Stack {} is ready {}", (Object)stackName, waiterResponse.matched().response().orElse(null));
        return stackName;
    }

    public void undeploy(String stack) {
        CloudFormationClient cfClient = this.stack2Client.get(stack);
        CloudFormationWaiter waiter = cfClient.waiter();
        DeleteStackRequest stackRequest = (DeleteStackRequest)DeleteStackRequest.builder().stackName(stack).build();
        cfClient.deleteStack(stackRequest);
        DescribeStacksRequest stacksRequest = (DescribeStacksRequest)DescribeStacksRequest.builder().stackName(stack).build();
        WaiterResponse waiterResponse = waiter.waitUntilStackDeleteComplete(stacksRequest);
        LOGGER.debug("Stack {} is deleted {}", (Object)stack, waiterResponse.matched().response().orElse(null));
        this.stack2Client.remove(stack);
        this.client2stacks.get(cfClient).remove(stack);
    }

    @Override
    public void close() {
        this.client2stacks.forEach((client, strings) -> client.close());
    }

    public String deployAndRegister(CloudFormationClient cfClient, String templateContent, Map<String, String> parameters) {
        String stack = this.deploy(cfClient, templateContent, parameters);
        this.client2stacks.putIfAbsent(cfClient, Collections.synchronizedSet(new HashSet()));
        this.client2stacks.get(cfClient).add(stack);
        this.stack2Client.put(stack, cfClient);
        return stack;
    }

    public void undeployAll() {
        this.stack2Client.forEach((stack, client) -> this.undeploy((String)stack));
    }
}

