/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import sunstone.aws.annotation.AwsResourceIdentificationAnnotation;
import sunstone.aws.impl.AwsIdentifiableSunstoneResource;
import sunstone.aws.impl.AwsLogger;
import sunstone.aws.impl.AwsSunstoneResourceInjector;
import sunstone.core.AnnotationUtils;
import sunstone.core.api.SunstoneResourceInjector;
import sunstone.core.spi.SunstoneResourceInjectorProvider;

public class AwsSunstoneResourceInjectorProvider
implements SunstoneResourceInjectorProvider {
    public Optional<SunstoneResourceInjector> create(Field field) {
        List resourceIdentifications = AnnotationUtils.findAnnotationsAnnotatedBy((Annotation[])field.getAnnotations(), AwsResourceIdentificationAnnotation.class);
        if (resourceIdentifications.isEmpty()) {
            return Optional.empty();
        }
        if (resourceIdentifications.size() > 1) {
            AwsLogger.DEFAULT.warn(String.format("Injected field %s is supposed to be annotated only by one annotation identifying a cloud resource. %s is accepted.", field, ((Annotation)resourceIdentifications.get(0)).toString()));
        }
        AwsIdentifiableSunstoneResource.Identification identification = new AwsIdentifiableSunstoneResource.Identification((Annotation)resourceIdentifications.get(0));
        if (identification.type != AwsIdentifiableSunstoneResource.UNSUPPORTED && identification.type.isTypeSupportedForInject(field.getType())) {
            return Optional.of(new AwsSunstoneResourceInjector(identification, field.getType()));
        }
        return Optional.empty();
    }
}

