/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import sunstone.aws.impl.AwsCloudFormationCloudDeploymentManager;
import sunstone.aws.impl.AwsUtils;
import sunstone.core.SunstoneStore;

class AwsSunstoneStore
extends SunstoneStore {
    private static final String AWS_CF_DEMPLOYMENT_MANAGER = "awsCfTemplateManager";
    private static final String AWS_REGION_2_CF_CLIENT = "awsCfClient";
    private static final String AWS_REGION_2_EC2_CLIENT = "awsEc2Clients";

    protected AwsSunstoneStore(ExtensionContext ctx) {
        super(ctx);
    }

    static AwsSunstoneStore get(ExtensionContext ctx) {
        return new AwsSunstoneStore(ctx);
    }

    AwsCloudFormationCloudDeploymentManager getAwsCfDemploymentManagerOrCreate() {
        return (AwsCloudFormationCloudDeploymentManager)this.getStore().getOrComputeIfAbsent((Object)AWS_CF_DEMPLOYMENT_MANAGER, k -> new AwsCloudFormationCloudDeploymentManager(), AwsCloudFormationCloudDeploymentManager.class);
    }

    CloudFormationClient getAwsCfClientOrCreate(String regionStr) {
        ConcurrentMap region2cfClient = (ConcurrentMap)this.getStore().getOrComputeIfAbsent((Object)AWS_REGION_2_CF_CLIENT, s -> new ConcurrentHashMap(), ConcurrentMap.class);
        return region2cfClient.computeIfAbsent(regionStr, r -> {
            CloudFormationClient client = AwsUtils.getCloudFormationClient(r);
            this.addSuiteLevelClosable((AutoCloseable)client);
            return client;
        });
    }

    Ec2Client getAwsEc2ClientOrCreate(String regionStr) {
        ConcurrentMap region2Ec2Client = (ConcurrentMap)this.getStore().getOrComputeIfAbsent((Object)AWS_REGION_2_EC2_CLIENT, s -> new ConcurrentHashMap(), ConcurrentMap.class);
        return region2Ec2Client.computeIfAbsent(regionStr, r -> {
            Ec2Client client = AwsUtils.getEC2Client(r);
            this.addSuiteLevelClosable((AutoCloseable)client);
            return client;
        });
    }
}

