/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.s3.S3Client;
import sunstone.aws.annotation.AwsAutoResolve;
import sunstone.aws.annotation.AwsEc2Instance;
import sunstone.aws.annotation.AwsRds;
import sunstone.aws.impl.AwsSunstoneStore;
import sunstone.aws.impl.AwsUtils;
import sunstone.core.SunstoneConfig;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneCloudResourceException;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;
import sunstone.inject.Hostname;

enum AwsIdentifiableSunstoneResource {
    UNSUPPORTED(null),
    AUTO((Class)AwsAutoResolve.class){
        final Class<?>[] supportedTypesForInjection = new Class[]{S3Client.class, Ec2Client.class, RdsClient.class};

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }
    }
    ,
    EC2_INSTANCE((Class)AwsEc2Instance.class){
        final Class<?>[] supportedTypesForInjection = new Class[]{Hostname.class, Instance.class};

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            if (!this.getRepresentedInjectionAnnotation().isAssignableFrom(injectionAnnotation.annotationType())) {
                throw new IllegalArgumentSunstoneException(String.format("Expected %s annotation type but got %s", this.getRepresentedInjectionAnnotation().getName(), injectionAnnotation.annotationType().getName()));
            }
            AwsEc2Instance vm = (AwsEc2Instance)injectionAnnotation;
            String vmNameTag = SunstoneConfig.resolveExpressionToString((String)vm.nameTag());
            String region = SunstoneConfig.resolveExpressionToString((String)vm.region());
            Optional<Instance> awsEc2 = AwsUtils.findEc2InstanceByNameTag(store.getAwsEc2ClientOrCreate(region), vmNameTag);
            return clazz.cast(awsEc2.orElseThrow(() -> new SunstoneCloudResourceException(String.format("Unable to find '%s' AWS EC2 instance in '%s' region.", vmNameTag, region))));
        }
    }
    ,
    RDS_SERVICE((Class)AwsRds.class){
        final Class<?>[] supportedTypesForInjection = new Class[]{Hostname.class, DBInstance.class};

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            if (!this.getRepresentedInjectionAnnotation().isAssignableFrom(injectionAnnotation.annotationType())) {
                throw new IllegalArgumentSunstoneException(String.format("Expected %s annotation type but got %s", this.getRepresentedInjectionAnnotation().getName(), injectionAnnotation.annotationType().getName()));
            }
            AwsRds rds = (AwsRds)injectionAnnotation;
            String vmNameTag = SunstoneConfig.resolveExpressionToString((String)rds.name());
            String region = SunstoneConfig.resolveExpressionToString((String)rds.region());
            Optional<DBInstance> awsRds = AwsUtils.findRdsInstanceByNameTag(store.getAwsRdsClientOrCreate(region), vmNameTag);
            return clazz.cast(awsRds.orElseThrow(() -> new SunstoneCloudResourceException(String.format("Unable to find '%s' AWS RDS instance in '%s' region.", vmNameTag, region))));
        }
    };

    private final Class<?> representedInjectionAnnotation;

    Class<?> getRepresentedInjectionAnnotation() {
        return this.representedInjectionAnnotation;
    }

    private AwsIdentifiableSunstoneResource(Class<?> representedInjectionAnnotation) {
        this.representedInjectionAnnotation = representedInjectionAnnotation;
    }

    public String toString() {
        if (this.representedInjectionAnnotation == null) {
            return "unsupported AwsIdentifiableSunstoneResource type";
        }
        return String.format("%s representing %s injection annotation", this.name(), this.representedInjectionAnnotation.getName());
    }

    boolean isTypeSupportedForInject(Class<?> type) {
        return false;
    }

    <T> T get(Annotation injectionAnnotation, AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
        throw new UnsupportedSunstoneOperationException(String.format("%s annotation is not supported for the type %s", injectionAnnotation.annotationType().getName(), this.toString()));
    }

    public static boolean isSupported(Annotation annotation) {
        return AwsIdentifiableSunstoneResource.getType(annotation) != UNSUPPORTED;
    }

    public static AwsIdentifiableSunstoneResource getType(Annotation annotation) {
        if (AwsEc2Instance.class.isAssignableFrom(annotation.annotationType())) {
            return EC2_INSTANCE;
        }
        if (AwsRds.class.isAssignableFrom(annotation.annotationType())) {
            return RDS_SERVICE;
        }
        if (AwsAutoResolve.class.isAssignableFrom(annotation.annotationType())) {
            return AUTO;
        }
        return UNSUPPORTED;
    }

    static class Identification {
        final Annotation identification;
        final AwsIdentifiableSunstoneResource type;

        Identification(Annotation annotation) {
            this.type = AwsIdentifiableSunstoneResource.getType(annotation);
            this.identification = annotation;
        }

        <T> T get(AwsSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return this.type.get(this.identification, store, clazz);
        }
    }
}

