/*
 * Decompiled with CFR 0.152.
 */
package sunstone.aws.impl;

import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.CloudFormationClientBuilder;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import sunstone.core.SunstoneConfig;

class AwsUtils {
    AwsUtils() {
    }

    private static AwsCredentialsProvider getCredentialsProvider() {
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)SunstoneConfig.getString((String)"sunstone.aws.accessKeyID"), (String)SunstoneConfig.getString((String)"sunstone.aws.secretAccessKey"));
        return StaticCredentialsProvider.create((AwsCredentials)credentials);
    }

    static boolean propertiesForAwsClientArePresent() {
        return SunstoneConfig.unwrap().isPropertyPresent("sunstone.aws.accessKeyID") && SunstoneConfig.unwrap().isPropertyPresent("sunstone.aws.secretAccessKey");
    }

    static Region getAndCheckRegion(String regionStr) {
        Region region = Region.of((String)regionStr);
        if (region == null) {
            throw new IllegalArgumentException("Unkown region " + regionStr);
        }
        return region;
    }

    static CloudFormationClient getCloudFormationClient(String region) {
        CloudFormationClient cfClient = (CloudFormationClient)((CloudFormationClientBuilder)((CloudFormationClientBuilder)CloudFormationClient.builder().region(AwsUtils.getAndCheckRegion(region))).credentialsProvider(AwsUtils.getCredentialsProvider())).build();
        return cfClient;
    }

    static Ec2Client getEC2Client(String region) {
        Ec2Client ec2Client = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().region(AwsUtils.getAndCheckRegion(region))).credentialsProvider(AwsUtils.getCredentialsProvider())).build();
        return ec2Client;
    }

    static S3Client getS3Client(String region) {
        S3Client s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(AwsUtils.getAndCheckRegion(region))).credentialsProvider(AwsUtils.getCredentialsProvider())).build();
        return s3Client;
    }

    static RdsClient getRdsClient(String region) {
        RdsClient rdsClient = (RdsClient)((RdsClientBuilder)((RdsClientBuilder)RdsClient.builder().region(AwsUtils.getAndCheckRegion(region))).credentialsProvider(AwsUtils.getCredentialsProvider())).build();
        return rdsClient;
    }

    static Optional<Instance> findEc2InstanceByNameTag(Ec2Client client, String name) {
        Filter runningInstancesFilter = (Filter)Filter.builder().name("instance-state-name").values(new String[]{"running"}).build();
        Filter tagFilter = (Filter)Filter.builder().name("tag:Name").values(new String[]{name}).build();
        DescribeInstancesRequest request = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(new Filter[]{runningInstancesFilter, tagFilter}).build();
        DescribeInstancesResponse response = client.describeInstances(request);
        for (Reservation reservation : response.reservations()) {
            for (Instance instance : reservation.instances()) {
                for (Tag tag : instance.tags()) {
                    if (!tag.key().equals("Name") || !tag.value().equals(name)) continue;
                    return Optional.of(instance);
                }
            }
        }
        return Optional.empty();
    }

    static Optional<DBInstance> findRdsInstanceByNameTag(RdsClient rdsClient, String name) {
        software.amazon.awssdk.services.rds.model.Filter nameFilter = (software.amazon.awssdk.services.rds.model.Filter)software.amazon.awssdk.services.rds.model.Filter.builder().name("db-instance-id").values(new String[]{name}).build();
        DescribeDbInstancesRequest request = (DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().filters(new software.amazon.awssdk.services.rds.model.Filter[]{nameFilter}).build();
        DescribeDbInstancesResponse response = rdsClient.describeDBInstances(request);
        return response.dbInstances().stream().filter(db -> db.dbInstanceStatus().equals("available")).findFirst();
    }
}

