/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import sunstone.annotation.WildFly;
import sunstone.azure.annotation.AzureResourceIdentificationAnnotation;
import sunstone.azure.impl.AzureWFIdentifiableSunstoneResource;
import sunstone.azure.impl.AzureWFLogger;
import sunstone.azure.impl.AzureWFSunstoneResourceInjector;
import sunstone.core.AnnotationUtils;
import sunstone.core.api.SunstoneResourceInjector;
import sunstone.core.spi.SunstoneResourceInjectorProvider;

public class AzureWFSunstoneResourceInjectorProvider
implements SunstoneResourceInjectorProvider {
    public Optional<SunstoneResourceInjector> create(Field field) {
        Annotation[] fieldAnnotations = field.getAnnotations();
        List resourceIdentifications = AnnotationUtils.findAnnotationsAnnotatedBy((Annotation[])fieldAnnotations, AzureResourceIdentificationAnnotation.class);
        if (resourceIdentifications.isEmpty()) {
            return Optional.empty();
        }
        Optional wildFly = AnnotationUtils.getAnnotation((Annotation[])fieldAnnotations, WildFly.class);
        AzureWFIdentifiableSunstoneResource.Identification identification = new AzureWFIdentifiableSunstoneResource.Identification((Annotation)resourceIdentifications.get(0));
        if (identification.type != AzureWFIdentifiableSunstoneResource.UNSUPPORTED && identification.type.isTypeSupportedForInject(field.getType())) {
            if (resourceIdentifications.size() > 1) {
                AzureWFLogger.DEFAULT.warn(String.format("Injected field %s is supposed to be annotated only by one annotation identifying a cloud resource. %s is accepted.", field, ((Annotation)resourceIdentifications.get(0)).toString()));
            }
            if (identification.type == AzureWFIdentifiableSunstoneResource.WEB_APP && wildFly.isPresent()) {
                AzureWFLogger.DEFAULT.info("Injecting from Azure Web App. WildFly always runs in standalone mode there, hence WildFly annotation doesn't matter");
            }
            if (!wildFly.isPresent()) {
                AzureWFLogger.DEFAULT.info(String.format("%s is missing %s annotation, sunstone azure-wildfly is going with standalone defaults", field, WildFly.class));
            }
            return Optional.of(new AzureWFSunstoneResourceInjector(identification, (WildFly)wildFly.orElse(new WildFly.WildFlyDefault()), field.getType()));
        }
        return Optional.empty();
    }
}

