/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.WebApp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.StringUtils;
import org.wildfly.extras.creaper.commands.deployments.Deploy;
import org.wildfly.extras.creaper.commands.deployments.Undeploy;
import org.wildfly.extras.creaper.core.CommandFailedException;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.annotation.WildFly;
import sunstone.azure.impl.AzureSunstoneStore;
import sunstone.azure.impl.AzureWFIdentifiableSunstoneResource;
import sunstone.azure.impl.AzureWFIdentifiableSunstoneResourceUtils;
import sunstone.azure.impl.AzureWFUtils;
import sunstone.azure.impl.FtpUtils;
import sunstone.core.api.SunstoneArchiveDeployer;
import sunstone.core.exceptions.IllegalArgumentSunstoneException;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

public class AzureWFArchiveDeployer
implements SunstoneArchiveDeployer {
    private final AzureWFIdentifiableSunstoneResource.Identification identification;
    private WildFly wildFly;

    AzureWFArchiveDeployer(AzureWFIdentifiableSunstoneResource.Identification identification, WildFly wildFly) {
        this.identification = identification;
        this.wildFly = wildFly;
    }

    static void deployToWebApp(AzureWFIdentifiableSunstoneResource.Identification resourceIdentification, InputStream is, AzureSunstoneStore store) throws Exception {
        Path tempFile = Files.createTempFile("sunstone-war-deployment-", ".war", new FileAttribute[0]);
        Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        WebApp azureWebApp = resourceIdentification.get(store, WebApp.class);
        azureWebApp.deployAsync(DeployType.WAR, tempFile.toFile()).block();
        AzureWFUtils.waitForWebAppDeployment(azureWebApp);
    }

    static void undeployFromWebApp(AzureWFIdentifiableSunstoneResource.Identification resourceIdentification, AzureSunstoneStore store) throws SunstoneException {
        WebApp webApp = resourceIdentification.get(store, WebApp.class);
        PublishingProfile profile = webApp.getPublishingProfile();
        FTPSClient ftpClient = new FTPSClient();
        String[] ftpUrlSegments = profile.ftpUrl().split("/", 2);
        String server = ftpUrlSegments[0];
        try {
            ftpClient.connect(server);
            ftpClient.enterLocalPassiveMode();
            ftpClient.login(profile.ftpUsername(), profile.ftpPassword());
            ftpClient.setFileType(2);
            FtpUtils.cleanDirectory((FTPClient)ftpClient, "/site/wwwroot/");
            ftpClient.disconnect();
            webApp.restartAsync().block();
            AzureWFUtils.waitForWebAppCleanState(webApp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static void deployToVmInstance(String deploymentName, AzureWFIdentifiableSunstoneResource.Identification resourceIdentification, WildFly wildFly, InputStream is, AzureSunstoneStore store) throws SunstoneException {
        try (OnlineManagementClient client = AzureWFIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(resourceIdentification, wildFly, store);){
            client.apply(new OnlineCommand[]{new Deploy.Builder(is, deploymentName, false).build()});
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void undeployFromVmInstance(String deploymentName, AzureWFIdentifiableSunstoneResource.Identification resourceIdentification, WildFly wildFly, AzureSunstoneStore store) throws SunstoneException {
        try (OnlineManagementClient client = AzureWFIdentifiableSunstoneResourceUtils.resolveOnlineManagementClient(resourceIdentification, wildFly, store);){
            client.apply(new OnlineCommand[]{new Undeploy.Builder(deploymentName).build()});
        }
        catch (CommandFailedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deploy(String deploymentName, Object object, ExtensionContext ctx) throws SunstoneException {
        InputStream is;
        AzureSunstoneStore store;
        block20: {
            store = AzureSunstoneStore.get((ExtensionContext)ctx);
            if (!this.identification.type.deployToWildFlySupported()) {
                throw new UnsupportedSunstoneOperationException(String.format("%s does not support WildFly deploy operation", new Object[]{this.identification.type}));
            }
            try {
                if (object instanceof Archive) {
                    is = ((ZipExporter)((Archive)object).as(ZipExporter.class)).exportAsInputStream();
                    break block20;
                }
                if (object instanceof File) {
                    is = new FileInputStream((File)object);
                    break block20;
                }
                if (object instanceof Path) {
                    is = new FileInputStream(((Path)object).toFile());
                    break block20;
                }
                if (object instanceof InputStream) {
                    is = (InputStream)object;
                    break block20;
                }
                throw new UnsupportedSunstoneOperationException("Unsupported type for deployment operation");
            }
            catch (FileNotFoundException e) {
                throw new SunstoneException((Throwable)e);
            }
        }
        try {
            switch (this.identification.type) {
                case VM_INSTANCE: {
                    if (StringUtils.isBlank((String)deploymentName)) {
                        throw new IllegalArgumentSunstoneException("Deployment name can not be empty for Azure virtual machine.");
                    }
                    AzureWFArchiveDeployer.deployToVmInstance(deploymentName, this.identification, this.wildFly, is, store);
                    break;
                }
                case WEB_APP: {
                    try {
                        if (!deploymentName.isEmpty()) {
                            throw new IllegalArgumentSunstoneException("Deployment name must be empty for Azure Web App. It is always ROOT.war and only WAR is supported.");
                        }
                        AzureWFArchiveDeployer.deployToWebApp(this.identification, is, store);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                default: {
                    throw new UnsupportedSunstoneOperationException(String.format("Unknown resource type for deploy operation to %s", new Object[]{this.identification.type}));
                }
            }
        }
        catch (Exception e) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new SunstoneException((Throwable)ex);
                }
            }
            throw e;
        }
    }

    public void undeploy(String deploymentName, ExtensionContext ctx) throws SunstoneException {
        AzureSunstoneStore store = AzureSunstoneStore.get((ExtensionContext)ctx);
        switch (this.identification.type) {
            case VM_INSTANCE: {
                if (StringUtils.isBlank((String)deploymentName)) {
                    throw new IllegalArgumentSunstoneException("Deployment name can not be empty for Azure virtual machine.");
                }
                AzureWFArchiveDeployer.undeployFromVmInstance(deploymentName, this.identification, this.wildFly, store);
                break;
            }
            case WEB_APP: {
                try {
                    if (!deploymentName.isEmpty()) {
                        throw new IllegalArgumentSunstoneException("Deployment name must be empty for Azure Web App. It is always ROOT.war and only WAR is supported.");
                    }
                    AzureWFArchiveDeployer.undeployFromWebApp(this.identification, store);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new UnsupportedSunstoneOperationException(String.format("Unknown resource type for undeploy operation from %s", new Object[]{this.identification.type}));
            }
        }
    }
}

