/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import sunstone.annotation.WildFly;
import sunstone.azure.annotation.AzureResourceIdentificationAnnotation;
import sunstone.azure.impl.AzureWFArchiveDeployer;
import sunstone.azure.impl.AzureWFIdentifiableSunstoneResource;
import sunstone.azure.impl.AzureWFLogger;
import sunstone.core.AnnotationUtils;
import sunstone.core.api.SunstoneArchiveDeployer;
import sunstone.core.spi.SunstoneArchiveDeployerProvider;

public class AzureWFArchiveDeployerProvider
implements SunstoneArchiveDeployerProvider {
    public Optional<SunstoneArchiveDeployer> create(Method method) {
        Annotation[] methodAnnotations = method.getAnnotations();
        List resourceIdentifications = AnnotationUtils.findAnnotationsAnnotatedBy((Annotation[])methodAnnotations, AzureResourceIdentificationAnnotation.class);
        if (resourceIdentifications.isEmpty()) {
            return Optional.empty();
        }
        Optional wildFly = AnnotationUtils.getAnnotation((Annotation[])methodAnnotations, WildFly.class);
        AzureWFIdentifiableSunstoneResource.Identification identification = new AzureWFIdentifiableSunstoneResource.Identification((Annotation)resourceIdentifications.get(0));
        if (identification.type != AzureWFIdentifiableSunstoneResource.UNSUPPORTED && identification.type.deployToWildFlySupported()) {
            if (resourceIdentifications.size() > 1) {
                AzureWFLogger.DEFAULT.warn(String.format("Deployment method %s is supposed to be annotated only by one annotation identifying a cloud resource. %s is accepted.", method, ((Annotation)resourceIdentifications.get(0)).toString()));
            }
            if (identification.type == AzureWFIdentifiableSunstoneResource.WEB_APP && wildFly.isPresent()) {
                AzureWFLogger.DEFAULT.info("Deploying to Azure Web App. WildFly always runs in standalone mode there, hence WildFly annotation doesn't matter");
            }
            if (!wildFly.isPresent()) {
                AzureWFLogger.DEFAULT.info(String.format("%s is missing %s, sunstone azure-wildfly is going with standalone defaults. ", method, WildFly.class));
            }
            return Optional.of(new AzureWFArchiveDeployer(identification, (WildFly)wildFly.orElse(new WildFly.WildFlyDefault())));
        }
        return Optional.empty();
    }
}

