/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import java.io.IOException;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.annotation.DomainMode;
import sunstone.annotation.OperatingMode;
import sunstone.annotation.StandaloneMode;
import sunstone.annotation.WildFly;
import sunstone.azure.impl.AzureSunstoneStore;
import sunstone.azure.impl.AzureWFIdentifiableSunstoneResource;
import sunstone.core.CreaperUtils;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;
import sunstone.inject.Hostname;

public class AzureWFIdentifiableSunstoneResourceUtils {
    static Hostname resolveHostname(AzureWFIdentifiableSunstoneResource.Identification identification, AzureSunstoneStore store) throws SunstoneException {
        switch (identification.type) {
            case VM_INSTANCE: {
                VirtualMachine vm = identification.get(store, VirtualMachine.class);
                return () -> ((PublicIpAddress)vm.getPrimaryPublicIPAddress()).ipAddress();
            }
            case WEB_APP: {
                WebApp app = identification.get(store, WebApp.class);
                return () -> ((WebApp)app).defaultHostname();
            }
        }
        throw new UnsupportedSunstoneOperationException("Unsupported type for getting hostname: " + (Object)((Object)identification.type));
    }

    static OnlineManagementClient resolveOnlineManagementClient(AzureWFIdentifiableSunstoneResource.Identification identification, WildFly wildfly, AzureSunstoneStore store) throws SunstoneException {
        try {
            if (identification.type == AzureWFIdentifiableSunstoneResource.VM_INSTANCE) {
                if (wildfly.mode() == OperatingMode.STANDALONE) {
                    return CreaperUtils.createStandaloneManagementClient((String)AzureWFIdentifiableSunstoneResourceUtils.resolveHostname(identification, store).get(), (StandaloneMode)wildfly.standalone());
                }
                if (wildfly.mode() == OperatingMode.DOMAIN) {
                    return CreaperUtils.createDomainManagementClient((String)AzureWFIdentifiableSunstoneResourceUtils.resolveHostname(identification, store).get(), (DomainMode)wildfly.domain());
                }
                throw new UnsupportedSunstoneOperationException("Unknown operating mode specified for injecting OnlineManagementClient.");
            }
            throw new UnsupportedSunstoneOperationException("Only Azure VM instance is supported for injecting OnlineManagementClient.");
        }
        catch (IOException e) {
            throw new SunstoneException((Throwable)e);
        }
    }
}

