/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import com.azure.resourcemanager.appservice.models.WebApp;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import sunstone.core.TimeoutUtils;

public class AzureWFUtils {
    static void waitForWebAppDeployment(WebApp app) throws InterruptedException, IOException {
        OkHttpClient client = new OkHttpClient();
        long timeout = TimeoutUtils.adjust((long)1200000L);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                String body;
                Response response = client.newCall(new Request.Builder().url("http://" + app.defaultHostname()).method("GET", null).build()).execute();
                int code = response.code();
                String string = body = response.body() != null ? response.body().string() : null;
                if (code >= 500 || AzureWFUtils.isWebAppDnsProblem(code, body) || AzureWFUtils.isEapWebAppWelcomePage(code, body)) continue;
                return;
            }
            catch (SocketTimeoutException e) {
                Thread.sleep(TimeoutUtils.adjust((long)500L));
            }
        }
        throw new RuntimeException("Timeout!");
    }

    static void waitForWebAppCleanState(WebApp app) throws InterruptedException, IOException {
        OkHttpClient client = new OkHttpClient();
        long timeout = TimeoutUtils.adjust((long)1200000L);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                String body;
                Response response = client.newCall(new Request.Builder().url("http://" + app.defaultHostname()).method("GET", null).build()).execute();
                int code = response.code();
                if (!AzureWFUtils.isEapWebAppWelcomePage(code, body = response.body() != null ? response.body().string() : null)) continue;
                return;
            }
            catch (SocketTimeoutException e) {
                Thread.sleep(TimeoutUtils.adjust((long)500L));
            }
        }
        throw new RuntimeException("Timeout!");
    }

    static void waitForWebApp(WebApp app) throws InterruptedException, IOException {
        OkHttpClient client = new OkHttpClient();
        long timeout = TimeoutUtils.adjust((long)1200000L);
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                String body;
                Response response = client.newCall(new Request.Builder().url("http://" + app.defaultHostname()).method("GET", null).build()).execute();
                int code = response.code();
                if (AzureWFUtils.isWebAppDnsProblem(code, body = response.body() != null ? response.body().string() : null) || code >= 500) continue;
                return;
            }
            catch (SocketTimeoutException e) {
                Thread.sleep(TimeoutUtils.adjust((long)500L));
            }
        }
        throw new RuntimeException("Timeout!");
    }

    private static boolean isWebAppDnsProblem(int code, String body) {
        return code == 404 && body != null && body.contains("404 Web Site not found.") && body.contains("Custom domain has not been configured inside Azure. See <a href=\"https://go.microsoft.com/fwlink/?linkid=2194614\">how to map an existing domain</a> to resolve this.") && body.contains("Client cache is still pointing the domain to old IP address. Clear the cache by running the command <i>ipconfig/flushdns.</i>");
    }

    private static boolean isEapWebAppWelcomePage(int code, String body) {
        return code == 200 && body != null && body.contains("Use deployment center to get code published from your client or setup continuous deployment.") && body.contains("Follow our quickstart guide and you'll have a full app ready in 5 minutes or less.<br>") && body.contains("<h4>Your app service is up and running.</h4>");
    }
}

