/*
 * Decompiled with CFR 0.152.
 */
package sunstone.azure.impl;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import sunstone.azure.annotation.AzureVirtualMachine;
import sunstone.azure.annotation.AzureWebApplication;
import sunstone.azure.impl.AzureIdentifiableSunstoneResource;
import sunstone.azure.impl.AzureSunstoneStore;
import sunstone.core.exceptions.SunstoneException;
import sunstone.core.exceptions.UnsupportedSunstoneOperationException;

enum AzureWFIdentifiableSunstoneResource {
    UNSUPPORTED(null),
    VM_INSTANCE((Class)AzureVirtualMachine.class){
        final Class<?>[] supportedTypesForInjection = new Class[]{OnlineManagementClient.class};

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        boolean deployToWildFlySupported() {
            return true;
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AzureSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return (T)AzureIdentifiableSunstoneResource.VM_INSTANCE.get(injectionAnnotation, store, clazz);
        }
    }
    ,
    WEB_APP((Class)AzureWebApplication.class){
        final Class<?>[] supportedTypesForInjection = new Class[0];

        @Override
        boolean isTypeSupportedForInject(Class<?> type) {
            return Arrays.stream(this.supportedTypesForInjection).anyMatch(clazz -> clazz.isAssignableFrom(type));
        }

        @Override
        boolean deployToWildFlySupported() {
            return true;
        }

        @Override
        <T> T get(Annotation injectionAnnotation, AzureSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return (T)AzureIdentifiableSunstoneResource.WEB_APP.get(injectionAnnotation, store, clazz);
        }
    };

    private final Class<?> representedInjectionAnnotation;

    Class<?> getRepresentedInjectionAnnotation() {
        return this.representedInjectionAnnotation;
    }

    private AzureWFIdentifiableSunstoneResource(Class<?> representedInjectionAnnotation) {
        this.representedInjectionAnnotation = representedInjectionAnnotation;
    }

    public String toString() {
        if (this.representedInjectionAnnotation == null) {
            return "unsupported AzureIdentifiableSunstoneResource type";
        }
        return String.format("%s representing %s injection annotation", this.name(), this.representedInjectionAnnotation.getName());
    }

    boolean isTypeSupportedForInject(Class<?> type) {
        return false;
    }

    boolean deployToWildFlySupported() {
        return false;
    }

    <T> T get(Annotation injectionAnnotation, AzureSunstoneStore store, Class<T> clazz) throws SunstoneException {
        throw new UnsupportedSunstoneOperationException(String.format("%s annotation is nto supported for the type %s", injectionAnnotation.annotationType().getName(), this.toString()));
    }

    public static boolean isSupported(Annotation annotation) {
        return AzureWFIdentifiableSunstoneResource.getType(annotation) != UNSUPPORTED;
    }

    public static AzureWFIdentifiableSunstoneResource getType(Annotation annotation) {
        if (AzureVirtualMachine.class.isAssignableFrom(annotation.annotationType())) {
            return VM_INSTANCE;
        }
        if (AzureWebApplication.class.isAssignableFrom(annotation.annotationType())) {
            return WEB_APP;
        }
        return UNSUPPORTED;
    }

    static class Identification {
        final Annotation identification;
        final AzureWFIdentifiableSunstoneResource type;

        Identification(Annotation annotation) {
            this.type = AzureWFIdentifiableSunstoneResource.getType(annotation);
            this.identification = annotation;
        }

        <T> T get(AzureSunstoneStore store, Class<T> clazz) throws SunstoneException {
            return this.type.get(this.identification, store, clazz);
        }
    }
}

