/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.vertx.AbstractVertxOptionsResourceDefinition;
import org.wildfly.extension.vertx.NamedVertxOptions;
import org.wildfly.extension.vertx.NamedVertxOptionsService;
import org.wildfly.extension.vertx.VertxOptionsAttributes;
import org.wildfly.extension.vertx.VertxSubsystemExtension;
import org.wildfly.extension.vertx.logging.VertxLogger;

class VertxOptionFileResourceDefinition
extends AbstractVertxOptionsResourceDefinition {
    static VertxOptionFileResourceDefinition INSTANCE = new VertxOptionFileResourceDefinition();

    VertxOptionFileResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"vertx-option-file"), (ResourceDescriptionResolver)VertxSubsystemExtension.getResourceDescriptionResolver("vertx", "vertx-option-file")).setAddHandler((OperationStepHandler)new VertxOptionFileAddHandler()).setRemoveHandler((OperationStepHandler)new AbstractVertxOptionsResourceDefinition.VertxOptionRemoveHandler()).setCapabilities(new RuntimeCapability[]{VERTX_OPTIONS_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AbstractVertxOptionsResourceDefinition.AttrWriteHandler handler = new AbstractVertxOptionsResourceDefinition.AttrWriteHandler();
        for (AttributeDefinition attr : VertxOptionsAttributes.getVertxOptionsFileAttributes()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    static JsonObject readJsonFromFile(String vertxOptionsFile, File configDir) throws OperationFailedException {
        Path path = Paths.get(vertxOptionsFile, new String[0]);
        if (path.isAbsolute()) {
            throw VertxLogger.VERTX_LOGGER.absoluteDirectoryNotAllowed(vertxOptionsFile);
        }
        path = configDir.toPath().resolve(vertxOptionsFile);
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path)) {
            String jsonContent;
            try {
                jsonContent = Files.readString(path);
            }
            catch (IOException e) {
                throw VertxLogger.VERTX_LOGGER.failedToReadVertxOptions(path.toString(), e);
            }
            if (jsonContent != null) {
                return new JsonObject(jsonContent);
            }
            return new JsonObject();
        }
        throw VertxLogger.VERTX_LOGGER.cannotReadVertxOptionsFile(path.toString());
    }

    static class VertxOptionFileAddHandler
    extends AbstractAddStepHandler {
        VertxOptionFileAddHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String optionFilePath;
            String name = context.getCurrentAddressValue();
            String string = optionFilePath = operation.hasDefined("path") ? VertxOptionsAttributes.VERTX_OPTION_FILE_PATH.resolveModelAttribute(context, operation).asString() : null;
            if (optionFilePath == null || optionFilePath.trim().isEmpty()) {
                throw VertxLogger.VERTX_LOGGER.noOptionsFileSpecified(name);
            }
            ServiceName vertxServiceName = VERTX_OPTIONS_CAPABILITY.getCapabilityServiceName(new String[]{name});
            CapabilityServiceBuilder vertxServiceBuilder = context.getCapabilityServiceTarget().addService();
            Consumer consumer = vertxServiceBuilder.provides(new ServiceName[]{vertxServiceName});
            Supplier serverEnvSupplier = vertxServiceBuilder.requires(ServerEnvironmentService.SERVICE_NAME);
            VertxOptions vertxOptions = new VertxOptions(VertxOptionFileResourceDefinition.readJsonFromFile(optionFilePath, ((ServerEnvironment)serverEnvSupplier.get()).getServerConfigurationDir()));
            NamedVertxOptions namedVertxOptions = new NamedVertxOptions(name, vertxOptions);
            vertxServiceBuilder.setInstance((Service)new NamedVertxOptionsService(namedVertxOptions, consumer));
            vertxServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

