/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import io.vertx.core.VertxOptions;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.vertx.AbstractVertxOptionsResourceDefinition;
import org.wildfly.extension.vertx.NamedVertxOptions;
import org.wildfly.extension.vertx.NamedVertxOptionsService;
import org.wildfly.extension.vertx.VertxOptionsAttributes;
import org.wildfly.extension.vertx.VertxOptionsRegistry;
import org.wildfly.extension.vertx.VertxSubsystemExtension;

class VertxOptionsResourceDefinition
extends AbstractVertxOptionsResourceDefinition {
    static VertxOptionsResourceDefinition INSTANCE = new VertxOptionsResourceDefinition();
    private static final SimpleOperationDefinition SHOW_VERTX_OPTIONS_INFO = new SimpleOperationDefinitionBuilder("show-info", (ResourceDescriptionResolver)VertxSubsystemExtension.getResourceDescriptionResolver("vertx", "vertx-option")).setReplyType(ModelType.OBJECT).setReplyValueType(ModelType.OBJECT).build();

    VertxOptionsResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"vertx-option"), (ResourceDescriptionResolver)VertxSubsystemExtension.getResourceDescriptionResolver("vertx", "vertx-option")).setAddHandler((OperationStepHandler)new VertxOptionAddHandler()).setRemoveHandler((OperationStepHandler)new AbstractVertxOptionsResourceDefinition.VertxOptionRemoveHandler()).setCapabilities(new RuntimeCapability[]{VERTX_OPTIONS_CAPABILITY}));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)SHOW_VERTX_OPTIONS_INFO, (OperationStepHandler)new ShowInfoHandler());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AbstractVertxOptionsResourceDefinition.AttrWriteHandler handler = new AbstractVertxOptionsResourceDefinition.AttrWriteHandler();
        for (AttributeDefinition attr : VertxOptionsAttributes.getVertxOptionsAttributes()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    static class VertxOptionAddHandler
    extends AbstractAddStepHandler {
        VertxOptionAddHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            VertxOptions vertxOptions = this.parseOptions(operation);
            NamedVertxOptions namedVertxOptions = new NamedVertxOptions(name, vertxOptions);
            String addressResolverOptionName = null;
            if (operation.hasDefined("address-resolver-option")) {
                addressResolverOptionName = VertxOptionsAttributes.ATTR_VERTX_OPTION_ADDRESS_RESOLVER.validateOperation(operation).asString();
            }
            NamedVertxOptionsService.installService(context, namedVertxOptions, addressResolverOptionName);
        }

        VertxOptions parseOptions(ModelNode operation) throws OperationFailedException {
            VertxOptions vertxOptions = new VertxOptions();
            if (operation.hasDefined("event-loop-pool-size")) {
                vertxOptions.setEventLoopPoolSize(VertxOptionsAttributes.ATTR_EVENTLOOP_POOL_SIZE.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("worker-pool-size")) {
                vertxOptions.setWorkerPoolSize(VertxOptionsAttributes.ATTR_WORKER_POOL_SIZE.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("internal-blocking-pool-size")) {
                vertxOptions.setInternalBlockingPoolSize(VertxOptionsAttributes.ATTR_INTERNAL_BLOCKING_POOL_SIZE.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("prefer-native-transport")) {
                vertxOptions.setPreferNativeTransport(VertxOptionsAttributes.ATTR_PREFER_NATIVE_TRANSPORT.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("blocked-thread-check-interval")) {
                vertxOptions.setBlockedThreadCheckInterval(VertxOptionsAttributes.ATTR_BLOCKED_THREAD_CHECK_INTERVAL.validateOperation(operation).asLong());
            }
            if (operation.hasDefined("blocked-thread-check-interval-unit")) {
                vertxOptions.setBlockedThreadCheckIntervalUnit(TimeUnit.valueOf(VertxOptionsAttributes.ATTR_BLOCKED_THREAD_CHECK_INTERVAL_UNIT.validateOperation(operation).asString()));
            }
            if (operation.hasDefined("max-eventloop-execute-time")) {
                vertxOptions.setMaxEventLoopExecuteTime(VertxOptionsAttributes.ATTR_MAX_EVENTLOOP_EXECUTE_TIME.validateOperation(operation).asLong());
            }
            if (operation.hasDefined("max-eventloop-execute-time-unit")) {
                vertxOptions.setMaxEventLoopExecuteTimeUnit(TimeUnit.valueOf(VertxOptionsAttributes.ATTR_MAX_EVENTLOOP_EXECUTE_TIME_UNIT.validateOperation(operation).asString()));
            }
            if (operation.hasDefined("max-worker-execute-time")) {
                vertxOptions.setMaxWorkerExecuteTime(VertxOptionsAttributes.ATTR_MAX_WORKER_EXECUTE_TIME.validateOperation(operation).asLong());
            }
            if (operation.hasDefined("max-worker-execute-time-unit")) {
                vertxOptions.setMaxWorkerExecuteTimeUnit(TimeUnit.valueOf(VertxOptionsAttributes.ATTR_MAX_WORKER_EXECUTE_TIME_UNIT.validateOperation(operation).asString()));
            }
            if (operation.hasDefined("warning-exception-time")) {
                vertxOptions.setWarningExceptionTime(VertxOptionsAttributes.ATTR_WARNING_EXECUTION_TIME.validateOperation(operation).asLong());
            }
            if (operation.hasDefined("warning-exception-time-unit")) {
                vertxOptions.setWarningExceptionTimeUnit(TimeUnit.valueOf(VertxOptionsAttributes.ATTR_WARNING_EXECUTION_TIME_UNIT.validateOperation(operation).asString()));
            }
            if (operation.hasDefined("classpath-resolving-enabled")) {
                vertxOptions.getFileSystemOptions().setClassPathResolvingEnabled(VertxOptionsAttributes.ATTR_FS_CLASS_PATH_RESOLVING_ENABLED.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("file-cache-enabled")) {
                vertxOptions.getFileSystemOptions().setFileCachingEnabled(VertxOptionsAttributes.ATTR_FS_FILE_CACHE_ENABLED.validateOperation(operation).asBoolean());
            }
            return vertxOptions;
        }
    }

    private static class ShowInfoHandler
    implements OperationStepHandler {
        private ShowInfoHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = new ModelNode();
            String name = context.getCurrentAddressValue();
            VertxOptions vertxOptions = VertxOptionsRegistry.getInstance().getNamedVertxOptions(name).getVertxOptions();
            result.set(ModelNode.fromJSONString((String)vertxOptions.toJson().encode()));
            context.getResult().set(result);
        }
    }
}

