/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.vertx.AbstractVertxOptionsResourceDefinition;
import org.wildfly.extension.vertx.VertxConstants;
import org.wildfly.extension.vertx.VertxSubsystemExtension;

class AddressResolverResourceDefinition
extends SimpleResourceDefinition
implements VertxConstants {
    static final RuntimeCapability<Void> VERTX_OPTIONS_ADDRESS_RESOLVER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.extension.vertx.options.address.resolver", (boolean)true, AddressResolverOptions.class).build();
    public static final SimpleAttributeDefinition ATTR_HOSTS_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hosts-value", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    public static final StringListAttributeDefinition ATTR_SERVERS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("servers").setRequired(false)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(true)).setAttributeParser(AttributeParser.COMMA_DELIMITED_STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.COMMA_STRING_LIST)).build();
    public static final SimpleAttributeDefinition ATTR_OPT_RES_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("opt-resource-enabled", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_CACHE_MIN_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-min-time-to-live", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_MAX_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-max-time-to-live", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_NEGATIVE_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-negative-time-to-live", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_QUERY_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("query-time-out", ModelType.LONG).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_MAX_QUERIES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-queries", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_RD_FLAG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rd-flag", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).build();
    public static final StringListAttributeDefinition ATTR_SEARCH_DOMAIN = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("search-domains").setRequired(false)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAllowExpression(true)).setAttributeParser(AttributeParser.COMMA_DELIMITED_STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.COMMA_STRING_LIST)).build();
    public static final SimpleAttributeDefinition ATTR_N_DOTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("n-dots", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_ROTATE_SERVERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rotate-servers", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_ROUND_ROBIN_INET_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("round-robin-inet-address", ModelType.BOOLEAN).setRequired(false)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition ATTR_HOSTS_REFRESH_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("hosts-refresh-period", ModelType.INT).setRequired(false)).setAllowExpression(true)).build();
    private static final List<AttributeDefinition> VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS = new ArrayList<AttributeDefinition>();
    static AddressResolverResourceDefinition INSTANCE;

    static List<AttributeDefinition> getVertxAddressResolverOptionsAttrs() {
        return VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS;
    }

    AddressResolverResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"address-resolver-option"), (ResourceDescriptionResolver)VertxSubsystemExtension.getResourceDescriptionResolver("vertx", "address-resolver-option")).setAddHandler((OperationStepHandler)new VertxAddressResolverOptionAddHandler()).setRemoveHandler((OperationStepHandler)new RemoveAddressResolverHandler()).setCapabilities(new RuntimeCapability[]{VERTX_OPTIONS_ADDRESS_RESOLVER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        AbstractVertxOptionsResourceDefinition.AttrWriteHandler handler = new AbstractVertxOptionsResourceDefinition.AttrWriteHandler(){

            @Override
            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
                return AbstractVertxOptionsResourceDefinition.isAddressResolverUsed(context, context.getCurrentAddressValue());
            }
        };
        for (AttributeDefinition attr : AddressResolverResourceDefinition.getVertxAddressResolverOptionsAttrs()) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)handler);
        }
    }

    static {
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_HOSTS_VALUE);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_SERVERS);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_OPT_RES_ENABLED);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_CACHE_MIN_TTL);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_MAX_TTL);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_NEGATIVE_TTL);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_QUERY_TIMEOUT);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_MAX_QUERIES);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_RD_FLAG);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_SEARCH_DOMAIN);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_N_DOTS);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_ROTATE_SERVERS);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_ROUND_ROBIN_INET_ADDRESS);
        VERTX_ADDRESS_RESOLVER_OPTIONS_ATTRS.add((AttributeDefinition)ATTR_HOSTS_REFRESH_PERIOD);
        INSTANCE = new AddressResolverResourceDefinition();
    }

    private static class VertxAddressResolverOptionAddHandler
    extends AbstractAddStepHandler {
        private VertxAddressResolverOptionAddHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            ServiceName addressResolverServiceName = VERTX_OPTIONS_ADDRESS_RESOLVER_CAPABILITY.getCapabilityServiceName(new String[]{name});
            CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addService();
            final Consumer consumer = serviceBuilder.provides(new ServiceName[]{addressResolverServiceName});
            final AddressResolverOptions addressResolverOptions = this.parseAddressResolverOptions(operation);
            Service addressResolverService = new Service(){

                public void start(StartContext startContext) throws StartException {
                    consumer.accept(addressResolverOptions);
                }

                public void stop(StopContext stopContext) {
                }
            };
            serviceBuilder.setInstance(addressResolverService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }

        private AddressResolverOptions parseAddressResolverOptions(ModelNode operation) throws OperationFailedException {
            List list;
            AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
            if (operation.hasDefined("hosts-value")) {
                addressResolverOptions.setHostsValue(Buffer.buffer((String)ATTR_HOSTS_VALUE.validateOperation(operation).asString()));
            }
            if (operation.hasDefined("servers")) {
                list = ATTR_SERVERS.validateOperation(operation).asList();
                addressResolverOptions.setServers(list.stream().map(ModelNode::asString).collect(Collectors.toList()));
            }
            if (operation.hasDefined("opt-resource-enabled")) {
                addressResolverOptions.setOptResourceEnabled(ATTR_OPT_RES_ENABLED.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("cache-min-time-to-live")) {
                addressResolverOptions.setCacheMinTimeToLive(ATTR_CACHE_MIN_TTL.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("cache-max-time-to-live")) {
                addressResolverOptions.setCacheMaxTimeToLive(ATTR_MAX_TTL.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("cache-negative-time-to-live")) {
                addressResolverOptions.setCacheNegativeTimeToLive(ATTR_NEGATIVE_TTL.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("query-time-out")) {
                addressResolverOptions.setQueryTimeout(ATTR_QUERY_TIMEOUT.validateOperation(operation).asLong());
            }
            if (operation.hasDefined("max-queries")) {
                addressResolverOptions.setMaxQueries(ATTR_MAX_QUERIES.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("rd-flag")) {
                addressResolverOptions.setRdFlag(ATTR_RD_FLAG.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("search-domains")) {
                list = ATTR_SEARCH_DOMAIN.validateOperation(operation).asList();
                addressResolverOptions.setSearchDomains(list.stream().map(ModelNode::asString).collect(Collectors.toList()));
            }
            if (operation.hasDefined("n-dots")) {
                addressResolverOptions.setNdots(ATTR_N_DOTS.validateOperation(operation).asInt());
            }
            if (operation.hasDefined("rotate-servers")) {
                addressResolverOptions.setRotateServers(ATTR_ROTATE_SERVERS.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("round-robin-inet-address")) {
                addressResolverOptions.setRoundRobinInetAddress(ATTR_ROUND_ROBIN_INET_ADDRESS.validateOperation(operation).asBoolean());
            }
            if (operation.hasDefined("hosts-refresh-period")) {
                addressResolverOptions.setHostsRefreshPeriod(ATTR_HOSTS_REFRESH_PERIOD.validateOperation(operation).asInt());
            }
            return addressResolverOptions;
        }
    }

    private static class RemoveAddressResolverHandler
    extends AbstractRemoveStepHandler {
        private RemoveAddressResolverHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = context.getCurrentAddressValue();
            boolean needsReload = AbstractVertxOptionsResourceDefinition.isAddressResolverUsed(context, name);
            ServiceName serviceName = VERTX_OPTIONS_ADDRESS_RESOLVER_CAPABILITY.getCapabilityServiceName(new String[]{name});
            context.removeService(serviceName);
            if (needsReload) {
                context.reloadRequired();
            }
        }
    }
}

