/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.extension.vertx.NamedVertxOptions;

public final class VertxOptionsRegistry {
    private final Map<String, NamedVertxOptions> namedVertxOptionsMap = new ConcurrentHashMap<String, NamedVertxOptions>();
    private static final VertxOptionsRegistry INSTANCE = new VertxOptionsRegistry();

    private VertxOptionsRegistry() {
    }

    public static VertxOptionsRegistry getInstance() {
        return INSTANCE;
    }

    public NamedVertxOptions getNamedVertxOptions(String name) {
        return this.namedVertxOptionsMap.get(name);
    }

    public void addVertxOptions(NamedVertxOptions namedVertxOptions) {
        this.namedVertxOptionsMap.put(namedVertxOptions.getName(), namedVertxOptions);
    }

    public void removeVertxOptions(String name) {
        this.namedVertxOptionsMap.remove(name);
    }
}

