/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.galleon.plugin.doc.generator.Deprecation;

record Attribute(String name, String description, String type, boolean nillable, boolean expressionsAllowed, String defaultValue, String min, String max, String accessType, String storage, Deprecation deprecation, String unit, String restartRequired, String capabilityReference, String stability, Collection<String> allowedValues, String jsonRepresentation) implements Comparable<Attribute>
{
    public static Attribute fromProperty(Property property) {
        String name = property.getName();
        String description = property.getValue().get("description").asString();
        String type = property.getValue().get("type").asString();
        boolean nilable = true;
        if (property.getValue().hasDefined("nillable")) {
            nilable = property.getValue().get("nillable").asBoolean();
        }
        String defaultValue = null;
        if (property.getValue().hasDefined("default")) {
            defaultValue = property.getValue().get("default").asString();
        }
        boolean expressionsAllowed = false;
        if (property.getValue().hasDefined("expressions-allowed")) {
            expressionsAllowed = property.getValue().get("expressions-allowed").asBoolean();
        }
        String min = null;
        if (property.getValue().hasDefined("min")) {
            min = property.getValue().get("min").asString();
        }
        String max = null;
        if (property.getValue().hasDefined("max")) {
            max = property.getValue().get("max").asString();
        }
        String accessType = property.getValue().get("access-type").asString();
        String storage = property.getValue().get("storage").asString();
        String unit = null;
        if (property.getValue().hasDefined("unit")) {
            unit = property.getValue().get("unit").asString();
        }
        String restartRequired = property.getValue().get("restart-required").asStringOrNull();
        String capabilityReference = property.getValue().get("capability-reference").asStringOrNull();
        String stability = property.getValue().get("stability").asStringOrNull();
        Set<String> allowedValues = Collections.emptySet();
        if (property.getValue().hasDefined("allowed")) {
            allowedValues = property.getValue().get("allowed").asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
        }
        String jsonRepresentation = property.getValue().toJSONString(false);
        return new Attribute(name, description, type, nilable, expressionsAllowed, defaultValue, min, max, accessType, storage, Deprecation.fromModel(property.getValue()), unit, restartRequired, capabilityReference, stability, allowedValues, jsonRepresentation);
    }

    @Override
    public int compareTo(Attribute o) {
        return this.name.compareTo(o.name);
    }
}

