/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.wildfly.galleon.plugin.doc.generator.PathAddress;
import org.wildfly.galleon.plugin.doc.generator.PathElement;

record Capability(String name, boolean dynamic, List<String> providerPoints) {
    static Capability fromModel(ModelNode capability, Map<String, Capability> globalCaps, String currentResourcePath) {
        List<String> providerPoints;
        String name = capability.get("name").asString();
        boolean dynamic = capability.get("dynamic").asBoolean(false);
        if (capability.hasDefined("registration-points")) {
            List registrationPoints = capability.get("registration-points").asList();
            providerPoints = registrationPoints.stream().map(ModelNode::asString).collect(Collectors.toList());
        } else {
            providerPoints = globalCaps.containsKey(name) ? globalCaps.get(name).providerPoints().stream().filter(s -> !s.equals(currentResourcePath)).collect(Collectors.toList()) : Collections.emptyList();
        }
        return new Capability(name, dynamic, providerPoints);
    }

    public Map<String, String> providerPointsUrls() {
        return this.providerPoints.stream().collect(Collectors.toMap(s -> s, v -> {
            PathAddress address = PathAddress.parseCLIStyleAddress(v);
            StringBuilder url = new StringBuilder();
            for (PathElement pe : address) {
                if (pe.isWildcard()) {
                    url.append(pe.getKey()).append('/');
                    continue;
                }
                url.append(pe.getKey()).append('/').append(pe.getValue()).append('/');
            }
            return url.toString();
        }));
    }

    static List<Capability> fromModelList(ModelNode capModel, Map<String, Capability> capabilities, PathAddress pathElements) {
        if (!capModel.isDefined()) {
            return Collections.emptyList();
        }
        LinkedList<Capability> r = new LinkedList<Capability>();
        capModel.asList().forEach(c -> r.add(Capability.fromModel(c, capabilities, pathElements.toCLIStyleString())));
        return r;
    }

    public String getCapabilityDescriptionUrl() {
        return "https://github.com/wildfly/wildfly-capabilities/tree/main/" + this.name.replaceAll("\\.", "/") + "/capability.adoc";
    }
}

