/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.galleon.plugin.doc.generator.Deprecation;

record Child(String name, String description, Deprecation deprecation, List<Child> children) implements Comparable<Child>
{
    public static Child fromProperty(Property property) {
        String name = property.getName();
        String description = property.getValue().get("description").asString();
        ArrayList<Child> registrations = new ArrayList<Child>();
        ModelNode modelDesc = property.getValue().get("model-description");
        if (modelDesc.isDefined()) {
            for (Property child : modelDesc.asPropertyList()) {
                if (child.getName().equals("*")) continue;
                registrations.add(new Child(child.getName(), child.getValue().get("description").asString(""), Deprecation.fromModel(child.getValue()), Collections.emptyList()));
            }
        }
        Collections.sort(registrations);
        return new Child(name, description, Deprecation.fromModel(property.getValue()), registrations);
    }

    @Override
    public int compareTo(Child o) {
        return this.name.compareTo(o.name);
    }
}

