/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import io.quarkus.qute.Template;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.jboss.dmr.ModelNode;
import org.wildfly.galleon.plugin.doc.generator.Breadcrumb;
import org.wildfly.galleon.plugin.doc.generator.Capability;
import org.wildfly.galleon.plugin.doc.generator.Child;
import org.wildfly.galleon.plugin.doc.generator.FeatureUtils;
import org.wildfly.galleon.plugin.doc.generator.FileUtils;
import org.wildfly.galleon.plugin.doc.generator.LogMessage;
import org.wildfly.galleon.plugin.doc.generator.LogMessageGenerator;
import org.wildfly.galleon.plugin.doc.generator.Metadata;
import org.wildfly.galleon.plugin.doc.generator.PathAddress;
import org.wildfly.galleon.plugin.doc.generator.PathElement;
import org.wildfly.galleon.plugin.doc.generator.Resource;
import org.wildfly.galleon.plugin.doc.generator.SimpleLog;
import org.wildfly.galleon.plugin.doc.generator.TemplateUtils;

public class DocGenerator {
    public static boolean generateModel(Path outputDirectory, Path managementAPIPath, Path featuresPath) throws IOException {
        return DocGenerator.generateModel(SimpleLog.SYSTEM_LOG, outputDirectory, managementAPIPath, featuresPath);
    }

    static boolean generateModel(SimpleLog log, Path outputDirectory, Path managementAPIPath, Path featuresPath) throws IOException {
        Path referencePath = outputDirectory.resolve("reference");
        Files.createDirectories(referencePath, new FileAttribute[0]);
        DocGenerator.copyResources(outputDirectory);
        Optional<Object> rootDescription = Optional.empty();
        Optional<Object> featuresDescription = Optional.empty();
        if (Files.exists(managementAPIPath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(managementAPIPath, new OpenOption[0]);){
                rootDescription = Optional.of(ModelNode.fromJSONStream((InputStream)in));
            }
            if (!Files.exists(featuresPath, new LinkOption[0])) {
                throw new RuntimeException("Missing features.json file");
            }
            in = Files.newInputStream(featuresPath, new OpenOption[0]);
            try {
                ModelNode featuresNode = ModelNode.fromJSONStream((InputStream)in);
                featuresDescription = Optional.of(DocGenerator.getInstantiableFeatures(featuresNode));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (rootDescription.isPresent()) {
            LinkedHashMap<String, Capability> globalCapabilities = new LinkedHashMap<String, Capability>(DocGenerator.getCapabilityMap((ModelNode)rootDescription.get()));
            DocGenerator.generateResource(referencePath, TemplateUtils.ENGINE.getTemplate("resource"), (Map)featuresDescription.get(), (ModelNode)rootDescription.get(), globalCapabilities, new PathElement[0]);
            if (log.isDebugEnabled()) {
                log.debug("\u270f\ufe0f Model reference pages generated");
            }
        } else {
            return false;
        }
        return true;
    }

    private static Map<String, ModelNode> getInstantiableFeatures(ModelNode features) {
        TreeMap<String, ModelNode> map = new TreeMap<String, ModelNode>();
        for (String name : features.keys()) {
            ModelNode feature;
            String url = FeatureUtils.featureToURL(name, feature = features.get(name));
            if (url == null) continue;
            map.put(url, feature);
        }
        return map;
    }

    public static void generate(SimpleLog log, Path docZipArchive, Path outputDirectory, Path metadataPath, Path managementAPIPath, Path featuresPath, Path localRepositoryPath) throws IOException {
        log.info("\ud83d\udd0e Generating Feature Pack Documentation");
        Path manifestPath = outputDirectory.resolve("META-INF");
        Files.createDirectories(manifestPath, new FileAttribute[0]);
        Files.copy(metadataPath, manifestPath.resolve("metadata.json"), StandardCopyOption.REPLACE_EXISTING);
        if (Files.exists(managementAPIPath, new LinkOption[0])) {
            Files.copy(managementAPIPath, manifestPath.resolve("management-api.json"), StandardCopyOption.REPLACE_EXISTING);
        }
        if (Files.exists(featuresPath, new LinkOption[0])) {
            Files.copy(featuresPath, manifestPath.resolve("features.json"), StandardCopyOption.REPLACE_EXISTING);
        }
        boolean hasModel = DocGenerator.generateModel(log, outputDirectory, managementAPIPath, featuresPath);
        Metadata metadata = Metadata.parse(metadataPath);
        boolean hasLogMessages = DocGenerator.generateLogMessages(log, outputDirectory, localRepositoryPath, metadataPath.getParent());
        DocGenerator.generateIndex(outputDirectory, TemplateUtils.ENGINE.getTemplate("index"), metadata, hasModel, hasLogMessages);
        if (log.isDebugEnabled()) {
            log.debug("\u270f\ufe0f Index page generated");
        }
        FileUtils.zipDirectory(outputDirectory, docZipArchive);
        log.info("\ud83d\udce6 Archive generated at " + String.valueOf(docZipArchive));
    }

    static boolean generateLogMessages(SimpleLog log, Path outputDirectory, Path localRepositoryPath, Path artifactListsParentPath) throws IOException {
        List<Path> artifactListPaths;
        log.info("\ud83d\udd0e Exporting log messages from artifact lists...");
        ArrayList<LogMessage> messages = new ArrayList<LogMessage>();
        try (Stream<Path> stream = Files.list(artifactListsParentPath);){
            artifactListPaths = stream.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith("-artifact-list.txt")).toList();
        }
        for (Path path2 : artifactListPaths) {
            messages.addAll(LogMessageGenerator.exportLogMessages(log, path2, localRepositoryPath));
        }
        if (messages.isEmpty()) {
            return false;
        }
        TreeMap<String, List> map = new TreeMap<String, List>();
        for (LogMessage msg : messages) {
            if (msg.code().isEmpty()) continue;
            map.computeIfAbsent(msg.code(), i -> new ArrayList()).add(msg);
        }
        map.forEach((s, msgs) -> Collections.sort(msgs));
        String string = TemplateUtils.ENGINE.getTemplate("log-message-reference").data("codes", map).render();
        FileUtils.writeToFile(outputDirectory.resolve("log-message-reference.html"), string);
        log.info("\u270f\ufe0f Log Message Reference page generated");
        return true;
    }

    private static void generateIndex(Path outputDirectory, Template index, Metadata metadata, boolean hasManagementAPI, boolean hasLogMessages) throws IOException {
        String content = index.data("metadata", (Object)metadata).data("hasManagementAPI", (Object)hasManagementAPI).data("hasLogMessages", (Object)hasLogMessages).render();
        FileUtils.writeToFile(outputDirectory.resolve("index.html"), content);
    }

    private static void generateResource(Path outputDirectory, Template resourceTemplate, Map<String, ModelNode> features, ModelNode model, Map<String, Capability> globalCapabilities, PathElement ... path) throws IOException {
        String currentUrl = DocGenerator.buildCurrentUrl(path);
        Resource resource = Resource.fromModelNode(PathAddress.pathAddress(path), model, features.get(currentUrl), globalCapabilities);
        String relativePathToContextRoot = DocGenerator.createRelativePathToContextRoot(currentUrl);
        String content = resourceTemplate.data("currentUrl", (Object)currentUrl).data("resource", (Object)resource).data("breadcrumbs", Breadcrumb.build(path)).data("relativePathToContextRoot", (Object)relativePathToContextRoot).render();
        Path dir = outputDirectory.resolve(currentUrl).normalize();
        FileUtils.writeToFile(dir.resolve("index.html"), content);
        for (Child child : resource.children()) {
            if (child.children().isEmpty()) {
                PathElement[] newPath = DocGenerator.addToPath(path, child.name(), "*");
                ModelNode childModel = model.get("children").get(child.name());
                if (!childModel.hasDefined("model-description")) continue;
                ModelNode newModel = childModel.get("model-description").get("*");
                if (newModel.hasDefined("operations")) {
                    newModel.get("operations");
                }
                DocGenerator.generateResource(outputDirectory, resourceTemplate, features, newModel, globalCapabilities, newPath);
                continue;
            }
            for (Child registration : child.children()) {
                PathElement[] newPath = DocGenerator.addToPath(path, child.name(), registration.name());
                ModelNode childModel = model.get("children").get(child.name());
                if (!childModel.hasDefined("model-description") || !childModel.get("model-description").hasDefined(registration.name())) continue;
                ModelNode newModel = childModel.get("model-description").get(registration.name());
                DocGenerator.generateResource(outputDirectory, resourceTemplate, features, newModel, globalCapabilities, newPath);
            }
        }
    }

    private static Map<String, Capability> getCapabilityMap(ModelNode fullModel) {
        ModelNode capabilitiesModel = fullModel.get("possible-capabilities");
        TreeMap<String, Capability> capabilityMap = new TreeMap<String, Capability>();
        if (capabilitiesModel.isDefined()) {
            capabilitiesModel.asList().forEach(cap -> {
                Capability capability = Capability.fromModel(cap, Collections.emptyMap(), null);
                capabilityMap.put(capability.name(), capability);
            });
        }
        return capabilityMap;
    }

    static String buildCurrentUrl(PathElement ... path) {
        StringBuilder sb = new StringBuilder();
        for (PathElement i : path) {
            if (!sb.toString().isEmpty()) {
                sb.append('/');
            }
            sb.append(i.getKey());
            if (i.isWildcard()) continue;
            sb.append('/');
            sb.append(i.getValue());
        }
        return sb.toString();
    }

    static String createRelativePathToContextRoot(String relativeUrl) {
        StringBuilder sb = new StringBuilder();
        int length = relativeUrl.isEmpty() ? 0 : relativeUrl.split("/").length;
        sb.append("../".repeat(length));
        return sb.toString();
    }

    private static PathElement[] addToPath(PathElement[] path, String key, String value) {
        PathElement[] newPath = new PathElement[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = new PathElement(key, value);
        return newPath;
    }

    private static void copyResources(Path outputDirectory) throws IOException {
        try (InputStream cssStream = DocGenerator.class.getResourceAsStream("/styles.css");){
            if (cssStream != null) {
                Files.copy(cssStream, outputDirectory.resolve("styles.css"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        cssStream = DocGenerator.class.getResourceAsStream("/scripts.js");
        try {
            if (cssStream != null) {
                Files.copy(cssStream, outputDirectory.resolve("scripts.js"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            if (cssStream != null) {
                cssStream.close();
            }
        }
    }
}

