/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.wildfly.galleon.plugin.doc.generator.Child;
import org.wildfly.galleon.plugin.doc.generator.Feature;

class FeatureUtils {
    FeatureUtils() {
    }

    static String featureToURL(String name, ModelNode featureSpec) {
        if (name.equals("server-root")) {
            return "";
        }
        FeatureAnnotation annotation = FeatureUtils.getAnnotation(featureSpec);
        if (annotation == null) {
            return null;
        }
        String[] tokens = name.split("\\.");
        HashMap<String, String> resolvedResources = new HashMap<String, String>();
        for (int i = 0; i < tokens.length - 1; ++i) {
            resolvedResources.put(tokens[i], tokens[i + 1]);
        }
        List addr = annotation.getElementAsList("addr-params");
        ArrayList<String> actualAddr = new ArrayList<String>();
        HashMap<String, String> defaults = new HashMap<String, String>();
        for (int i = 0; i < addr.size(); ++i) {
            String addrParam = (String)addr.get(i);
            for (ModelNode p : featureSpec.get("params").asList()) {
                String pName = p.get("name").asString();
                if (!addrParam.equals(pName)) continue;
                if (p.has("feature-id") && p.get("feature-id").asBoolean()) {
                    if (p.has("default")) {
                        if (p.get("default").asString().equals("GLN_UNDEFINED")) {
                            if (!addrParam.equals("host") || i == 0) continue;
                            actualAddr.add(addrParam);
                            continue;
                        }
                        defaults.put(pName, p.get("default").asString());
                    }
                } else {
                    defaults.put(pName, (String)resolvedResources.get(pName));
                }
                actualAddr.add(addrParam);
            }
        }
        StringBuilder url = new StringBuilder();
        for (int i = 0; i < actualAddr.size(); ++i) {
            String t = (String)actualAddr.get(i);
            String val = (String)defaults.get(t);
            url.append(url.length() != 0 ? "/" : "");
            if (val == null) {
                url.append(t);
                continue;
            }
            url.append(t).append("/").append(val);
        }
        if (annotation.hasElement("complex-attribute")) {
            url.append(".").append(annotation.getElement("complex-attribute"));
        }
        return url.toString();
    }

    static FeatureAnnotation getAnnotation(ModelNode descr) {
        if (!descr.hasDefined("annotation")) {
            return null;
        }
        ModelNode annotationNode = descr.require("annotation");
        FeatureAnnotation annotation = new FeatureAnnotation("jboss-op");
        for (Property property : annotationNode.asPropertyList()) {
            annotation.setElement(property.getName(), property.getValue().asString());
        }
        return annotation;
    }

    static Set<Feature> buildFeatures(ModelNode node, List<Child> childs) {
        if (node == null) {
            return Collections.emptySet();
        }
        TreeSet<Feature> set = new TreeSet<Feature>();
        FeatureAnnotation annotation = FeatureUtils.getAnnotation(node);
        String featureName = node.get("name").asString();
        String[] address = featureName.split("\\.");
        List addr = annotation.getElementAsList("addr-params");
        HashMap<String, String> resolvedResources = new HashMap<String, String>();
        for (int i = 0; i < address.length - 1; ++i) {
            resolvedResources.put(address[i], address[i + 1]);
        }
        TreeMap<String, CallSite> idParams = new TreeMap<String, CallSite>();
        TreeMap<String, CallSite> params = new TreeMap<String, CallSite>();
        StringBuilder xml = new StringBuilder();
        xml.append("&lt;feature spec=\"").append(featureName).append("\"&gt;\n");
        for (ModelNode modelNode : node.get("params").asList()) {
            String pName = modelNode.get("name").asString();
            if (modelNode.has("feature-id") && modelNode.get("feature-id").asBoolean()) {
                if (!modelNode.has("default")) {
                    idParams.put(pName, (CallSite)((Object)("  &lt;param name=\"" + pName + "\" value=\"{resource name}\"/&gt;\n")));
                    continue;
                }
                if (!modelNode.get("default").asString().equals("GLN_UNDEFINED") || !pName.equals("host") || ((String)addr.get(0)).equals("host")) continue;
                idParams.put(pName, (CallSite)((Object)("  &lt;param name=\"" + pName + "\" value=\"{resource name}\"/&gt;\n")));
                continue;
            }
            if (modelNode.has("default")) continue;
            if (addr.contains(pName)) {
                String resourceName = (String)resolvedResources.get(pName);
                if (resourceName == null) {
                    resourceName = "{resource name}";
                }
                idParams.put(pName, (CallSite)((Object)("  &lt;param name=\"" + pName + "\" value=\"" + resourceName + "\"/&gt;\n")));
                continue;
            }
            params.put(pName, (CallSite)((Object)("  &lt;param name=\"" + pName + "\" value=\"{value}\"/&gt;\n")));
        }
        for (Map.Entry entry : idParams.entrySet()) {
            xml.append((String)entry.getValue());
        }
        for (Map.Entry entry : params.entrySet()) {
            xml.append((String)entry.getValue());
        }
        xml.append("&lt;feature/&gt;");
        Feature current = new Feature(featureName, xml.toString());
        set.add(current);
        if (node.has("children")) {
            ModelNode modelNode = node.get("children");
            int featureNameLength = featureName.length();
            for (String child : modelNode.keys()) {
                if (!child.startsWith(featureName)) continue;
                String cName = child.substring(featureNameLength + 1);
                boolean found = false;
                for (Child c : childs) {
                    if (!cName.startsWith(c.name())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                set.addAll(FeatureUtils.buildFeatures(modelNode.get(child), Collections.emptyList()));
            }
        }
        return set;
    }
}

