/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    static void zipDirectory(Path sourceDirPath, Path zipPath) throws IOException {
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
             Stream<Path> stream = Files.walk(sourceDirPath, new FileVisitOption[0]);){
            Path basePath = sourceDirPath.getParent();
            stream.forEach(path -> {
                try {
                    Object zipEntryName = basePath.relativize((Path)path).toString().replace("\\", "/");
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!((String)zipEntryName).endsWith("/")) {
                            zipEntryName = (String)zipEntryName + "/";
                        }
                        zs.putNextEntry(new ZipEntry((String)zipEntryName));
                        zs.closeEntry();
                    } else {
                        zs.putNextEntry(new ZipEntry((String)zipEntryName));
                        Files.copy(path, zs);
                        zs.closeEntry();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    static void writeToFile(Path file, String content) throws IOException {
        Path parentDir = file.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.writeString(file, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

