/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.wildfly.galleon.plugin.doc.generator.LogMessage;
import org.wildfly.galleon.plugin.doc.generator.SimpleLog;

public class LogMessageGenerator {
    private static final String MESSAGE_LOGGER_ANNOTATION = "org.jboss.logging.annotations.MessageLogger";
    private static final String LOG_MESSAGE_ANNOTATION = "org.jboss.logging.annotations.LogMessage";
    private static final String MESSAGE_ANNOTATION = "org.jboss.logging.annotations.Message";
    private static final int DEFAULT_MESSAGE_ID_LENGTH = 6;
    private static final String DEFAULT_LOG_LEVEL = "INFO";
    private static final String VOID_DESCRIPTOR = "V";
    private static final String VOID_TYPE = "void";
    private static final String JAR_EXTENSION = ".jar";
    private static final String CLASS_EXTENSION = ".class";

    static List<LogMessage> exportLogMessages(SimpleLog log, Path artifactListFile, Path localRepositoryPath) throws IOException {
        ArrayList<LogMessage> messages = new ArrayList<LogMessage>();
        List<String> lines = Files.readAllLines(artifactListFile);
        for (String line : lines) {
            LogMessageGenerator.processArtifactLine(log, line, localRepositoryPath, messages);
        }
        return messages;
    }

    private static void processArtifactLine(SimpleLog log, String line, Path localRepositoryPath, List<LogMessage> messages) {
        if (line.trim().isEmpty()) {
            return;
        }
        String[] parts = line.split(",", 2);
        if (parts.length != 2) {
            log.debug("Invalid CSV line format: " + line);
            return;
        }
        Path filePath = Path.of(parts[1].trim(), new String[0]);
        if (LogMessageGenerator.isJarFile(filePath)) {
            Path jar = LogMessageGenerator.append(localRepositoryPath, filePath);
            try {
                LogMessageGenerator.processJarFile(log, jar, messages);
            }
            catch (IOException e) {
                log.debug("Failed to process JAR file: " + String.valueOf(jar) + " - " + e.getMessage());
            }
        }
    }

    private static boolean isJarFile(Path filePath) {
        return filePath.toString().toLowerCase().endsWith(JAR_EXTENSION);
    }

    private static void processJarFile(final SimpleLog log, Path file, final Collection<LogMessage> messages) throws IOException {
        try (FileSystem zipFs = LogMessageGenerator.zipFs(file);){
            for (Path dir : zipFs.getRootDirectories()) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(LogMessageGenerator.CLASS_EXTENSION)) {
                            try (DataInputStream d = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                                ClassFile classFile = new ClassFile(d);
                                LogMessageGenerator.handleClass(classFile, messages);
                            }
                            catch (Exception e) {
                                log.debug("Failed to process class file: " + String.valueOf(file) + " - " + e.getMessage());
                            }
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
        }
    }

    private static void handleClass(ClassFile classFile, Collection<LogMessage> messages) {
        AnnotationsAttribute attr = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        if (attr == null) {
            return;
        }
        for (Annotation annotation : attr.getAnnotations()) {
            if (!MESSAGE_LOGGER_ANNOTATION.equals(annotation.getTypeName())) continue;
            String code = ((StringMemberValue)annotation.getMemberValue("projectCode")).getValue();
            MemberValue lengthValue = annotation.getMemberValue("length");
            int length = lengthValue == null ? 6 : ((IntegerMemberValue)lengthValue).getValue();
            LogMessageGenerator.handleMessageLogger(classFile, code, length, messages);
        }
    }

    private static void handleMessageLogger(ClassFile classFile, String code, int length, Collection<LogMessage> messages) {
        for (MethodInfo method : Collections.unmodifiableList(classFile.getMethods())) {
            String logLevel = null;
            String message = null;
            int msgId = -1;
            AnnotationsAttribute attr = (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations");
            if (attr == null) continue;
            for (Annotation annotation : attr.getAnnotations()) {
                if (LOG_MESSAGE_ANNOTATION.equals(annotation.getTypeName())) {
                    MemberValue level = annotation.getMemberValue("level");
                    logLevel = level == null ? DEFAULT_LOG_LEVEL : ((EnumMemberValue)level).getValue();
                    continue;
                }
                if (!MESSAGE_ANNOTATION.equals(annotation.getTypeName())) continue;
                message = ((StringMemberValue)annotation.getMemberValue("value")).getValue();
                MemberValue id = annotation.getMemberValue("id");
                if (id == null) continue;
                msgId = ((IntegerMemberValue)id).getValue();
            }
            if (message == null) continue;
            LogMessage l = new LogMessage(logLevel, code, message, length, msgId, LogMessageGenerator.extractReturnType(method));
            messages.add(l);
        }
    }

    private static String extractReturnType(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        descriptor = descriptor.replace("/", ".");
        if ((descriptor = descriptor.replace(";", "")).startsWith("L")) {
            descriptor = descriptor.substring(1);
        }
        if (VOID_DESCRIPTOR.equals(descriptor)) {
            return VOID_TYPE;
        }
        return descriptor;
    }

    private static FileSystem zipFs(Path path) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI uri = URI.create("jar:" + String.valueOf(path.toUri()));
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            return FileSystems.newFileSystem(uri, env);
        }
    }

    public static Path append(Path base, Path toAppend) {
        if (toAppend.isAbsolute()) {
            toAppend = toAppend.subpath(0, toAppend.getNameCount());
        }
        return base.resolve(toAppend);
    }
}

