/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public record Metadata(String groupId, String artifactId, String version, String name, String description, List<String> licenses, String url, @JsonProperty(value="scm-url") String scmUrl, List<Layer> layers) {
    static Metadata parse(Path file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Metadata metadata = (Metadata)mapper.readValue(file.toFile(), Metadata.class);
        return Metadata.sortedMetadata(metadata);
    }

    private static Metadata sortedMetadata(Metadata metadata) {
        List<Layer> sortedLayers = metadata.layers() != null ? metadata.layers().stream().map(Metadata::sortedLayer).sorted(Comparator.comparing(Layer::name)).toList() : null;
        return new Metadata(metadata.groupId(), metadata.artifactId(), metadata.version(), metadata.name(), metadata.description(), metadata.licenses(), metadata.url(), metadata.scmUrl(), sortedLayers);
    }

    private static Layer sortedLayer(Layer layer) {
        List<LayerDependency> sortedDependencies = layer.dependencies() != null ? layer.dependencies().stream().sorted(Comparator.comparing(LayerDependency::name)).toList() : null;
        List<Property> sortedProperties = layer.properties() != null ? layer.properties().stream().sorted(Comparator.comparing(Property::name)).toList() : null;
        List<AttributeConfiguration> sortedConfigurations = layer.configurations() != null ? layer.configurations().stream().sorted(Comparator.comparing(AttributeConfiguration::address).thenComparing(AttributeConfiguration::attribute)).toList() : null;
        Set sortedPackages = layer.packages() != null ? (Set)layer.packages().stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new)) : null;
        return new Layer(layer.name(), layer.stability(), sortedDependencies, layer.managementModel(), sortedProperties, sortedConfigurations, sortedPackages);
    }

    public boolean containsLayer(String layerName) {
        return this.layers().stream().anyMatch(l -> layerName.equals(l.name));
    }

    public record Layer(String name, String stability, List<LayerDependency> dependencies, ObjectNode managementModel, List<Property> properties, List<AttributeConfiguration> configurations, Set<String> packages) {
        public String description() {
            return this.properties.stream().filter(p -> p.name().equals("org.wildfly.description")).map(Property::value).findFirst().orElse(null);
        }

        public String note() {
            return this.properties.stream().filter(p -> p.name().equals("org.wildfly.note")).map(Property::value).findFirst().orElse(null);
        }

        public String prettyManagementModel() {
            if (this.managementModel == null) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            try {
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.managementModel);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
    }

    public record AttributeConfiguration(@JsonProperty(value="_address") String address, String attribute, @JsonProperty(value="system-properties") Set<String> systemProperties, @JsonProperty(value="environment-variables") Set<String> envVars) {
    }

    public record Property(String name, String value) {
    }

    public record LayerDependency(String name, boolean optional) {
    }
}

