/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.galleon.plugin.doc.generator.Deprecation;

record Operation(String name, String description, boolean readOnly, boolean runtimeOnly, String stability, Deprecation deprecation, List<Parameter> parameters, Reply reply, String jsonRepresentation) implements Comparable<Operation>
{
    public static Operation fromProperty(Property property) {
        String name = property.getName();
        ModelNode model = property.getValue();
        String description = model.get("description").asString();
        boolean readOnly = false;
        if (model.hasDefined("read-only")) {
            readOnly = model.get("read-only").asBoolean();
        }
        boolean runtimeOnly = false;
        if (model.hasDefined("runtime-only")) {
            runtimeOnly = model.get("runtime-only").asBoolean();
        }
        String stability = model.get("stability").asStringOrNull();
        String jsonRepresentation = model.toJSONString(false);
        List<Parameter> parameters = Collections.emptyList();
        if (model.hasDefined("request-properties")) {
            parameters = model.get("request-properties").asPropertyList().stream().map(Parameter::fromProperty).toList();
        }
        Reply reply = null;
        if (model.hasDefined("reply-properties")) {
            reply = Reply.fromModelNode(model.get("reply-properties"));
        }
        return new Operation(name, description, readOnly, runtimeOnly, stability, Deprecation.fromModel(model), parameters, reply, jsonRepresentation);
    }

    @Override
    public int compareTo(Operation o) {
        return this.name.compareTo(o.name);
    }

    record Reply(String type, String valueType, String description) {
        public static Reply fromModelNode(ModelNode model) {
            if (!model.hasDefined("type")) {
                return null;
            }
            String returnType = model.get("type").asString();
            String returnDescription = model.get("description").asString("");
            ModelNode returnValueType = model.get("value-type");
            StringWriter writer = new StringWriter();
            returnValueType.writeString(new PrintWriter(writer), false);
            String valueType = writer.toString();
            return new Reply(returnType, returnValueType.isDefined() ? valueType : null, returnDescription);
        }
    }

    record Parameter(String name, String type, String description, boolean required, boolean nillable, boolean expressionsAllowed, String defaultValue) {
        public static Parameter fromProperty(Property property) {
            String name = property.getName();
            ModelNode value = property.getValue();
            String type = value.get("type").asString();
            String description = value.get("description").asStringOrNull();
            boolean required = value.get("required").asBoolean();
            boolean nillable = value.get("nillable").asBoolean();
            boolean expressionsAllowed = value.get("expressions-allowed").asBoolean();
            String defaultValue = value.get("default").asStringOrNull();
            return new Parameter(name, type, description, required, nillable, expressionsAllowed, defaultValue);
        }
    }
}

