/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.wildfly.galleon.plugin.doc.generator.Attribute;
import org.wildfly.galleon.plugin.doc.generator.Capability;
import org.wildfly.galleon.plugin.doc.generator.Child;
import org.wildfly.galleon.plugin.doc.generator.Deprecation;
import org.wildfly.galleon.plugin.doc.generator.Feature;
import org.wildfly.galleon.plugin.doc.generator.Operation;
import org.wildfly.galleon.plugin.doc.generator.PathAddress;

record Resource(String description, String storage, Deprecation deprecation, List<Capability> capabilities, List<Child> children, List<Attribute> attributes, List<Operation> operations, Set<Feature> features) {
    public static Resource fromModelNode(PathAddress pathAddress, ModelNode node, ModelNode featureNode, Map<String, Capability> capabilities) {
        List<Child> children = Collections.emptyList();
        if (node.hasDefined("children")) {
            children = node.get("children").asPropertyList().stream().map(Child::fromProperty).sorted().toList();
        }
        List<Attribute> attributes = Collections.emptyList();
        if (node.hasDefined("attributes")) {
            attributes = node.get("attributes").asPropertyList().stream().map(Attribute::fromProperty).sorted().toList();
        }
        List<Operation> operations = Collections.emptyList();
        if (node.hasDefined("operations")) {
            operations = node.get("operations").asPropertyList().stream().map(Operation::fromProperty).sorted().toList();
        }
        String storage = null;
        if (node.hasDefined("storage")) {
            storage = node.get("storage").asString("configuration");
        }
        String description = null;
        if (node.hasDefined("description")) {
            description = node.get("description").asString();
        }
        Set<Feature> features = Feature.fromModelNode(featureNode, children);
        return new Resource(description, storage, Deprecation.fromModel(node), Capability.fromModelList(node.get("capabilities"), capabilities, pathAddress), children, attributes, operations, features == null ? Collections.emptySet() : features);
    }
}

