/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.doc.generator;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

public class TemplateUtils {
    static final Engine ENGINE = TemplateUtils.engine();

    private static Engine engine() {
        return Engine.builder().addLocator(new TemplateLocator(){

            /*
             * Enabled aggressive exception aggregation
             */
            public Optional<TemplateLocator.TemplateLocation> locate(String id) {
                block13: {
                    String resourcePath = "/templates/" + id + ".html";
                    try (InputStream stream = this.getClass().getResourceAsStream(resourcePath);){
                        Optional<TemplateLocator.TemplateLocation> optional;
                        if (stream == null) break block13;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                            final String content = reader.lines().collect(Collectors.joining("\n"));
                            optional = Optional.of(new TemplateLocator.TemplateLocation(){

                                public Reader read() {
                                    return new StringReader(content);
                                }

                                public Optional<Variant> getVariant() {
                                    return Optional.of(new Variant(Locale.getDefault(), StandardCharsets.UTF_8, "text/html"));
                                }
                            });
                        }
                        return optional;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return Optional.empty();
            }
        }).addDefaults().addValueResolver((ValueResolver)new ReflectionValueResolver()).build();
    }
}

