/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.bnd.signatures.ArrayTypeSignature;
import aQute.bnd.signatures.ClassSignature;
import aQute.bnd.signatures.ClassTypeSignature;
import aQute.bnd.signatures.FieldSignature;
import aQute.bnd.signatures.JavaTypeSignature;
import aQute.bnd.signatures.MethodSignature;
import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Result;
import aQute.bnd.signatures.SimpleClassTypeSignature;
import aQute.bnd.signatures.ThrowsSignature;
import aQute.bnd.signatures.TypeArgument;
import aQute.bnd.signatures.TypeParameter;
import aQute.lib.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.Action;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.SignatureRule;
import org.eclipse.transformer.action.impl.ChangesImpl;
import org.eclipse.transformer.action.impl.InputBufferImpl;
import org.eclipse.transformer.action.impl.SelectionRuleImpl;
import org.eclipse.transformer.action.impl.SignatureRuleImpl;
import org.eclipse.transformer.util.ByteData;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.InputStreamData;
import org.slf4j.Logger;

public abstract class ActionImpl
implements Action {
    private final Logger logger;
    private final boolean isTerse;
    private final boolean isVerbose;
    private final InputBufferImpl buffer;
    private final SelectionRuleImpl selectionRule;
    protected final SignatureRuleImpl signatureRule;
    protected final List<ChangesImpl> changes;
    protected int numActiveChanges;
    protected ChangesImpl activeChanges;
    protected ChangesImpl lastActiveChanges;

    public ActionImpl(Logger logger, boolean isTerse, boolean isVerbose, InputBufferImpl buffer, SelectionRuleImpl selectionRule, SignatureRuleImpl signatureRule) {
        this.logger = logger;
        this.isTerse = isTerse;
        this.isVerbose = isVerbose;
        this.buffer = buffer;
        this.selectionRule = selectionRule;
        this.signatureRule = signatureRule;
        this.changes = new ArrayList<ChangesImpl>();
        this.numActiveChanges = 0;
        this.activeChanges = null;
        this.lastActiveChanges = null;
    }

    public <A extends ActionImpl> A createUsing(ActionInit<A> init) {
        return init.apply(this.getLogger(), this.getIsTerse(), this.getIsVerbose(), this.getBuffer(), this.getSelectionRule(), this.getSignatureRule());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean getIsTerse() {
        return this.isTerse;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public void trace(String message, Object ... parms) {
        this.getLogger().trace(message, parms);
    }

    public void debug(String message, Object ... parms) {
        this.getLogger().debug(message, parms);
    }

    public void info(String message, Object ... parms) {
        this.getLogger().info(message, parms);
    }

    public void terse(String message, Object ... parms) {
        if (this.getIsTerse()) {
            this.info(message, parms);
        }
    }

    public void verbose(String message, Object ... parms) {
        if (this.getIsVerbose()) {
            this.info(message, parms);
        }
    }

    public void warn(String message, Object ... parms) {
        this.getLogger().warn(message, parms);
    }

    public void error(String message, Object ... parms) {
        this.getLogger().error(message, parms);
    }

    public void error(String message, Throwable th, Object ... parms) {
        Logger useLogger = this.getLogger();
        if (!useLogger.isErrorEnabled()) {
            return;
        }
        if (parms.length != 0) {
            message = message.replace("{}", "%s");
            message = String.format(message, parms);
        }
        useLogger.error(message, th);
    }

    @Override
    public InputBufferImpl getBuffer() {
        return this.buffer;
    }

    @Override
    public byte[] getInputBuffer() {
        return this.getBuffer().getInputBuffer();
    }

    @Override
    public void setInputBuffer(byte[] inputBuffer) {
        this.getBuffer().setInputBuffer(inputBuffer);
    }

    public SelectionRuleImpl getSelectionRule() {
        return this.selectionRule;
    }

    @Override
    public boolean select(String resourceName) {
        return this.getSelectionRule().select(resourceName);
    }

    public boolean selectIncluded(String resourceName) {
        return this.getSelectionRule().selectIncluded(resourceName);
    }

    public boolean rejectExcluded(String resourceName) {
        return this.getSelectionRule().rejectExcluded(resourceName);
    }

    @Override
    public SignatureRuleImpl getSignatureRule() {
        return this.signatureRule;
    }

    public BundleData getBundleUpdate(String symbolicName) {
        return this.getSignatureRule().getBundleUpdate(symbolicName);
    }

    public Map<String, String> getPackageRenames() {
        return this.getSignatureRule().getPackageRenames();
    }

    public Map<String, String> getPackageVersions() {
        return this.getSignatureRule().getPackageVersions();
    }

    public String replacePackage(String initialName) {
        return this.getSignatureRule().replacePackage(initialName);
    }

    public String replaceBinaryPackage(String initialName) {
        return this.getSignatureRule().replaceBinaryPackage(initialName);
    }

    public String replaceEmbeddedPackages(String embeddingText) {
        return this.getSignatureRule().replacePackages(embeddingText);
    }

    public String replaceText(String inputFileName, String text) {
        return this.getSignatureRule().replaceText(inputFileName, text);
    }

    public String transformConstantAsBinaryType(String inputConstant) {
        return this.getSignatureRule().transformConstantAsBinaryType(inputConstant);
    }

    public String transformConstantAsBinaryType(String inputConstant, boolean simpleSubstitution) {
        return this.getSignatureRule().transformConstantAsBinaryType(inputConstant, simpleSubstitution);
    }

    public String transformBinaryType(String inputName) {
        return this.getSignatureRule().transformBinaryType(inputName);
    }

    public String transformConstantAsDescriptor(String inputConstant) {
        return this.getSignatureRule().transformConstantAsDescriptor(inputConstant);
    }

    public String transformConstantAsDescriptor(String inputConstant, boolean simpleSubstitution) {
        return this.getSignatureRule().transformConstantAsDescriptor(inputConstant, simpleSubstitution);
    }

    public String transformDescriptor(String inputDescriptor) {
        return this.getSignatureRule().transformDescriptor(inputDescriptor);
    }

    public String transform(String input, SignatureRule.SignatureType signatureType) {
        return this.getSignatureRule().transform(input, signatureType);
    }

    public ClassSignature transform(ClassSignature classSignature) {
        return this.getSignatureRule().transform(classSignature);
    }

    public FieldSignature transform(FieldSignature fieldSignature) {
        return this.getSignatureRule().transform(fieldSignature);
    }

    public MethodSignature transform(MethodSignature methodSignature) {
        return this.getSignatureRule().transform(methodSignature);
    }

    public Result transform(Result type) {
        return this.getSignatureRule().transform(type);
    }

    public ThrowsSignature transform(ThrowsSignature type) {
        return this.getSignatureRule().transform(type);
    }

    public ArrayTypeSignature transform(ArrayTypeSignature inputType) {
        return this.getSignatureRule().transform(inputType);
    }

    public TypeParameter transform(TypeParameter inputTypeParameter) {
        return this.getSignatureRule().transform(inputTypeParameter);
    }

    public ClassTypeSignature transform(ClassTypeSignature inputType) {
        return this.getSignatureRule().transform(inputType);
    }

    public SimpleClassTypeSignature transform(SimpleClassTypeSignature inputSignature) {
        return this.getSignatureRule().transform(inputSignature);
    }

    public TypeArgument transform(TypeArgument inputArgument) {
        return this.getSignatureRule().transform(inputArgument);
    }

    public JavaTypeSignature transform(JavaTypeSignature type) {
        return this.getSignatureRule().transform(type);
    }

    public ReferenceTypeSignature transform(ReferenceTypeSignature type) {
        return this.getSignatureRule().transform(type);
    }

    public String transformDirectString(String initialValue) {
        return this.getSignatureRule().getDirectString(initialValue);
    }

    public String transformConstantString(String initialValue, String className) {
        return this.getSignatureRule().getConstantString(initialValue, className);
    }

    public abstract String getAcceptExtension();

    @Override
    public boolean accept(String resourceName) {
        return this.accept(resourceName, null);
    }

    @Override
    public boolean accept(String resourceName, File resourceFile) {
        return resourceName.toLowerCase().endsWith(this.getAcceptExtension());
    }

    protected ChangesImpl newChanges() {
        return new ChangesImpl();
    }

    protected void startRecording(String inputName) {
        if (this.getIsVerbose()) {
            this.info("Start processing [ {} ] using [ {} ]", new Object[]{inputName, this.getActionType()});
        }
        if (this.numActiveChanges == this.changes.size()) {
            this.activeChanges = this.newChanges();
            this.changes.add(this.activeChanges);
        } else {
            this.activeChanges = this.changes.get(this.numActiveChanges);
            this.activeChanges.clearChanges();
        }
        ++this.numActiveChanges;
    }

    protected void stopRecording(String inputName) {
        if (this.getIsVerbose()) {
            boolean nameChanged = this.activeChanges.hasResourceNameChange();
            boolean contentChanged = this.activeChanges.hasNonResourceNameChanges();
            String changeText = nameChanged && contentChanged ? "Name and content changes" : (nameChanged ? "Name changes" : (contentChanged ? "Content changes" : "No changes"));
            this.info("Stop processing [ {} ] using [ {} ]: {}", new Object[]{inputName, this.getActionType(), changeText});
        }
        this.lastActiveChanges = this.activeChanges;
        --this.numActiveChanges;
        this.activeChanges = this.numActiveChanges == 0 ? null : this.changes.get(this.numActiveChanges);
    }

    @Override
    public ChangesImpl getActiveChanges() {
        return this.activeChanges;
    }

    protected void setResourceNames(String inputResourceName, String outputResourceName) {
        ChangesImpl useChanges = this.getActiveChanges();
        useChanges.setInputResourceName(inputResourceName);
        useChanges.setOutputResourceName(outputResourceName);
    }

    @Override
    public void addReplacement() {
        this.getActiveChanges().addReplacement();
    }

    @Override
    public void addReplacements(int additions) {
        this.getActiveChanges().addReplacements(additions);
    }

    @Override
    public boolean hasChanges() {
        return this.getActiveChanges().hasChanges();
    }

    @Override
    public boolean hasResourceNameChange() {
        return this.getActiveChanges().hasResourceNameChange();
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.getActiveChanges().hasNonResourceNameChanges();
    }

    @Override
    public ChangesImpl getLastActiveChanges() {
        return this.lastActiveChanges;
    }

    @Override
    public boolean hadChanges() {
        return this.getLastActiveChanges().hasChanges();
    }

    @Override
    public boolean hadResourceNameChange() {
        return this.getLastActiveChanges().hasResourceNameChange();
    }

    @Override
    public boolean hadNonResourceNameChanges() {
        return this.getLastActiveChanges().hasNonResourceNameChanges();
    }

    @Override
    public boolean useStreams() {
        return false;
    }

    protected ByteData read(String inputName, InputStream inputStream, int inputCount) throws TransformException {
        ByteData readData;
        byte[] readBytes = this.getInputBuffer();
        try {
            readData = FileUtils.read(inputName, inputStream, readBytes, inputCount);
        }
        catch (IOException e) {
            throw new TransformException("Failed to read raw bytes [ " + inputName + " ] count [ " + inputCount + " ]", e);
        }
        this.setInputBuffer(readData.data);
        return readData;
    }

    protected void write(ByteData outputData, OutputStream outputStream) throws TransformException {
        try {
            outputStream.write(outputData.data, outputData.offset, outputData.length);
        }
        catch (IOException e) {
            throw new TransformException("Failed to write [ " + outputData.name + " ] at [ " + outputData.offset + " ] count [ " + outputData.length + " ]", e);
        }
    }

    @Override
    public InputStreamData apply(String inputName, InputStream inputStream) throws TransformException {
        return this.apply(inputName, inputStream, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStreamData apply(String inputName, InputStream inputStream, int inputCount) throws TransformException {
        this.startRecording(inputName);
        try {
            InputStreamData inputStreamData = this.basicApply(inputName, inputStream, inputCount);
            return inputStreamData;
        }
        finally {
            this.stopRecording(inputName);
        }
    }

    public InputStreamData basicApply(String inputName, InputStream inputStream, int inputCount) throws TransformException {
        ByteData outputData;
        String className = this.getClass().getSimpleName();
        String methodName = "apply";
        this.debug("[ {}.{} ]: Requested [ {} ] [ {} ]", className, methodName, inputName, inputCount);
        ByteData inputData = this.read(inputName, inputStream, inputCount);
        this.debug("[ {}.{} ]: Obtained [ {} ] [ {} ] [ {} ]", className, methodName, inputName, inputData.length, inputData.data);
        try {
            outputData = this.apply(inputName, inputData.data, inputData.length);
        }
        catch (Throwable th) {
            this.error("Transform failure [ {} ]", th, inputName);
            outputData = null;
        }
        if (outputData == null) {
            this.debug("[ {}.{} ]: Null transform", className, methodName);
            outputData = inputData;
        } else {
            this.debug("[ {}.{} ]: Active transform [ {} ] [ {} ] [ {} ]", className, methodName, outputData.name, outputData.length, outputData.data);
        }
        return new InputStreamData(outputData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String inputName, InputStream inputStream, long inputCount, OutputStream outputStream) throws TransformException {
        this.startRecording(inputName);
        try {
            this.basicApply(inputName, inputStream, inputCount, outputStream);
        }
        finally {
            this.stopRecording(inputName);
        }
    }

    public void basicApply(String inputName, InputStream inputStream, long inputCount, OutputStream outputStream) throws TransformException {
        ByteData outputData;
        int intInputCount = FileUtils.verifyArray(0, inputCount);
        String className = this.getClass().getSimpleName();
        String methodName = "apply";
        this.debug("[ {}.{} ]: Requested [ {} ] [ {} ]", className, methodName, inputName, inputCount);
        ByteData inputData = this.read(inputName, inputStream, intInputCount);
        this.debug("[ {}.{} ]: Obtained [ {} ] [ {} ]", className, methodName, inputName, inputData.length);
        try {
            outputData = this.apply(inputName, inputData.data, inputData.length);
        }
        catch (Throwable th) {
            this.error("Transform failure [ {} ]", th, inputName);
            outputData = null;
        }
        if (outputData == null) {
            this.debug("[ {}.{} ]: Null transform", className, methodName);
            outputData = inputData;
        } else {
            this.debug("[ {}.{} ]: Active transform [ {} ] [ {} ]", className, methodName, outputData.name, outputData.length);
        }
        this.write(outputData, outputStream);
    }

    protected abstract ByteData apply(String var1, byte[] var2, int var3) throws TransformException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(String inputName, File inputFile, File outputFile) throws TransformException {
        long inputLength = inputFile.length();
        this.debug("Input [ {} ] Length [ {} ]", inputName, inputLength);
        InputStream inputStream = this.openInputStream(inputFile);
        try {
            OutputStream outputStream = this.openOutputStream(outputFile);
            try {
                this.apply(inputName, inputStream, inputLength, outputStream);
            }
            finally {
                this.closeOutputStream(outputFile, outputStream);
            }
        }
        finally {
            this.closeInputStream(inputFile, inputStream);
        }
    }

    protected InputStream openInputStream(File inputFile) throws TransformException {
        try {
            return IO.stream(inputFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to open input [ " + inputFile.getAbsolutePath() + " ]", e);
        }
    }

    protected void closeInputStream(File inputFile, InputStream inputStream) throws TransformException {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new TransformException("Failed to close input [ " + inputFile.getAbsolutePath() + " ]", e);
        }
    }

    private OutputStream openOutputStream(File outputFile) throws TransformException {
        try {
            return IO.outputStream(outputFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to open output [ " + outputFile.getAbsolutePath() + " ]", e);
        }
    }

    private void closeOutputStream(File outputFile, OutputStream outputStream) throws TransformException {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new TransformException("Failed to close output [ " + outputFile.getAbsolutePath() + " ]", e);
        }
    }

    public static interface ActionInit<A extends ActionImpl> {
        public A apply(Logger var1, boolean var2, boolean var3, InputBufferImpl var4, SelectionRuleImpl var5, SignatureRuleImpl var6);
    }
}

